/*
 * Decompiled with CFR 0.152.
 */
package COM.rl;

import COM.rl.ClassEntry;
import COM.rl.FieldEntry;
import COM.rl.MethodEntry;
import COM.rl.PackageEntry;
import COM.rl.obf.Cl;
import COM.rl.obf.ClassTree;
import COM.rl.obf.Fd;
import COM.rl.obf.Md;
import COM.rl.obf.Pk;
import COM.rl.obf.TreeItem;
import COM.rl.obf.classfile.ClassFile;
import COM.rl.obf.classfile.ClassFileException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NameProvider {
    public static final int CLASSIC_MODE = 0;
    public static final int CHANGE_NOTHING_MODE = 1;
    public static final int DEOBFUSCATION_MODE = 2;
    public static final int REOBFUSCATION_MODE = 3;
    public static final String DEFAULT_CFG_FILE_NAME = "retroguard.cfg";
    public static int uniqueStart = 100000;
    public static int currentMode = 0;
    public static boolean quiet = false;
    public static boolean oldHash = false;
    public static boolean repackage = true;
    public static boolean fixShadowed = true;
    public static boolean multipass = true;
    public static boolean verbose = false;
    public static boolean fullMap = false;
    private static Set<File> obfFiles = new HashSet<File>();
    private static Set<File> reobFiles = new HashSet<File>();
    private static File npLog = null;
    private static File roLog = null;
    private static Set<String> protectedPackages = new HashSet<String>();
    private static Map<String, PackageEntry> packagesObf2Deobf = new HashMap<String, PackageEntry>();
    private static Map<String, PackageEntry> packagesDeobf2Obf = new HashMap<String, PackageEntry>();
    private static Map<String, ClassEntry> classesObf2Deobf = new HashMap<String, ClassEntry>();
    private static Map<String, ClassEntry> classesDeobf2Obf = new HashMap<String, ClassEntry>();
    private static Map<String, MethodEntry> methodsObf2Deobf = new HashMap<String, MethodEntry>();
    private static Map<String, MethodEntry> methodsDeobf2Obf = new HashMap<String, MethodEntry>();
    private static Map<String, FieldEntry> fieldsObf2Deobf = new HashMap<String, FieldEntry>();
    private static Map<String, FieldEntry> fieldsDeobf2Obf = new HashMap<String, FieldEntry>();

    public static String[] parseCommandLine(String[] args) throws IOException {
        int idx;
        if (args.length > 0 && (args[0].equalsIgnoreCase("-searge") || args[0].equalsIgnoreCase("-notch"))) {
            return NameProvider.parseNameSheetModeArgs(args);
        }
        if (args.length < 5) {
            return args;
        }
        try {
            idx = Integer.parseInt(args[4]);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Invalid start index: " + args[4]);
        }
        uniqueStart = idx;
        String[] newArgs = new String[4];
        for (int i = 0; i < 4; ++i) {
            newArgs[i] = args[i];
        }
        return newArgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] parseNameSheetModeArgs(String[] args) throws IOException {
        if (args.length < 2) {
            return null;
        }
        if (args[0].equalsIgnoreCase("-searge")) {
            currentMode = 2;
        } else if (args[0].equalsIgnoreCase("-notch")) {
            currentMode = 3;
            repackage = true;
        } else {
            return null;
        }
        String configFileName = args[1];
        File configFile = new File(configFileName);
        if (!configFile.exists() || !configFile.isFile()) {
            throw new FileNotFoundException("Could not find config file " + configFileName);
        }
        String reobinput = null;
        String reoboutput = null;
        FileReader fileReader = null;
        BufferedReader reader = null;
        String[] newArgs = new String[4];
        try {
            fileReader = new FileReader(configFile);
            reader = new BufferedReader(fileReader);
            String line = "";
            while (line != null) {
                String value;
                String[] defines;
                line = reader.readLine();
                if (line == null || line.trim().startsWith("#") || (defines = line.split("=")).length <= 1) continue;
                defines[1] = line.substring(defines[0].length() + 1).trim();
                defines[0] = defines[0].trim();
                if (defines[0].equalsIgnoreCase("deob")) {
                    File obfFile = new File(defines[1]);
                    if (obfFile.isFile()) {
                        obfFiles.add(obfFile);
                        continue;
                    }
                    throw new FileNotFoundException("Could not find obf file " + defines[1]);
                }
                if (defines[0].equalsIgnoreCase("packages")) {
                    File packagesFile = new File(defines[1]);
                    if (packagesFile.isFile()) {
                        obfFiles.add(packagesFile);
                        continue;
                    }
                    throw new FileNotFoundException("Could not find packages file " + defines[1]);
                }
                if (defines[0].equalsIgnoreCase("classes")) {
                    File classesFile = new File(defines[1]);
                    if (classesFile.isFile()) {
                        obfFiles.add(classesFile);
                        continue;
                    }
                    throw new FileNotFoundException("Could not find classes file " + defines[1]);
                }
                if (defines[0].equalsIgnoreCase("methods")) {
                    File methodsFile = new File(defines[1]);
                    if (methodsFile.isFile()) {
                        obfFiles.add(methodsFile);
                        continue;
                    }
                    throw new FileNotFoundException("Could not find methods file " + defines[1]);
                }
                if (defines[0].equalsIgnoreCase("fields")) {
                    File fieldsFile = new File(defines[1]);
                    if (fieldsFile.isFile()) {
                        obfFiles.add(fieldsFile);
                        continue;
                    }
                    throw new FileNotFoundException("Could not find fields file " + defines[1]);
                }
                if (defines[0].equalsIgnoreCase("reob")) {
                    File reobFile = new File(defines[1]);
                    if (reobFile.isFile()) {
                        reobFiles.add(reobFile);
                        continue;
                    }
                    if (currentMode != 3) continue;
                    throw new FileNotFoundException("Could not find reob file " + defines[1]);
                }
                if (defines[0].equalsIgnoreCase("input")) {
                    newArgs[0] = defines[1];
                    continue;
                }
                if (defines[0].equalsIgnoreCase("output")) {
                    newArgs[1] = defines[1];
                    continue;
                }
                if (defines[0].equalsIgnoreCase("reobinput")) {
                    reobinput = defines[1];
                    continue;
                }
                if (defines[0].equalsIgnoreCase("reoboutput")) {
                    reoboutput = defines[1];
                    continue;
                }
                if (defines[0].equalsIgnoreCase("script")) {
                    newArgs[2] = defines[1];
                    continue;
                }
                if (defines[0].equalsIgnoreCase("log")) {
                    newArgs[3] = defines[1];
                    continue;
                }
                if (defines[0].equalsIgnoreCase("nplog")) {
                    npLog = new File(defines[1]);
                    if (!npLog.exists() || npLog.isFile()) continue;
                    npLog = null;
                    continue;
                }
                if (defines[0].equalsIgnoreCase("rolog")) {
                    roLog = new File(defines[1]);
                    if (!roLog.exists() || roLog.isFile()) continue;
                    roLog = null;
                    continue;
                }
                if (defines[0].equalsIgnoreCase("startindex")) {
                    try {
                        int start;
                        uniqueStart = start = Integer.parseInt(defines[1]);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new NumberFormatException("Invalid start index: " + defines[1]);
                    }
                }
                if (defines[0].equalsIgnoreCase("protectedpackage")) {
                    protectedPackages.add(defines[1]);
                    continue;
                }
                if (defines[0].equalsIgnoreCase("quiet")) {
                    String value2 = defines[1].substring(0, 1);
                    if (!value2.equalsIgnoreCase("1") && !value2.equalsIgnoreCase("t") && !value2.equalsIgnoreCase("y")) continue;
                    quiet = true;
                    continue;
                }
                if (defines[0].equalsIgnoreCase("oldhash")) {
                    String value3 = defines[1].substring(0, 1);
                    if (!value3.equalsIgnoreCase("1") && !value3.equalsIgnoreCase("t") && !value3.equalsIgnoreCase("y")) continue;
                    oldHash = true;
                    continue;
                }
                if (defines[0].equalsIgnoreCase("fixshadowed")) {
                    String value4 = defines[1].substring(0, 1);
                    if (!value4.equalsIgnoreCase("0") && !value4.equalsIgnoreCase("f") && !value4.equalsIgnoreCase("n")) continue;
                    fixShadowed = false;
                    continue;
                }
                if (defines[0].equalsIgnoreCase("incremental")) {
                    String value5 = defines[1].substring(0, 1);
                    if (!value5.equalsIgnoreCase("1") && !value5.equalsIgnoreCase("t") && !value5.equalsIgnoreCase("y")) continue;
                    repackage = false;
                    continue;
                }
                if (defines[0].equalsIgnoreCase("multipass")) {
                    String value6 = defines[1].substring(0, 1);
                    if (!value6.equalsIgnoreCase("0") && !value6.equalsIgnoreCase("f") && !value6.equalsIgnoreCase("n")) continue;
                    multipass = false;
                    continue;
                }
                if (defines[0].equalsIgnoreCase("verbose")) {
                    String value7 = defines[1].substring(0, 1);
                    if (!value7.equalsIgnoreCase("1") && !value7.equalsIgnoreCase("t") && !value7.equalsIgnoreCase("y")) continue;
                    verbose = true;
                    continue;
                }
                if (!defines[0].equalsIgnoreCase("fullmap") || !(value = defines[1].substring(0, 1)).equalsIgnoreCase("1") && !value.equalsIgnoreCase("t") && !value.equalsIgnoreCase("y")) continue;
                fullMap = true;
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (fileReader != null) {
                    fileReader.close();
                }
            }
            catch (IOException e) {}
        }
        if (currentMode == 3) {
            newArgs[0] = reobinput;
            newArgs[1] = reoboutput;
        }
        if (newArgs[0] == null || newArgs[1] == null || newArgs[2] == null || newArgs[3] == null) {
            return null;
        }
        NameProvider.initLogfiles();
        NameProvider.readSRGFiles();
        return newArgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initLogfiles() throws IOException {
        File logFile = null;
        if (currentMode == 2) {
            logFile = npLog;
        } else if (currentMode == 3) {
            logFile = roLog;
        }
        if (logFile != null) {
            FileWriter writer = null;
            try {
                writer = new FileWriter(logFile);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private static void readSRGFiles() throws IOException {
        block3: {
            block2: {
                if (currentMode != 2) break block2;
                for (File f : obfFiles) {
                    NameProvider.readSRGFile(f);
                }
                break block3;
            }
            if (currentMode != 3) break block3;
            for (File f : reobFiles) {
                NameProvider.readSRGFile(f);
            }
        }
    }

    private static void readSRGFile(File f) throws IOException {
        List<String> lines = NameProvider.readAllLines(f);
        int line_number = 1;
        for (String line : lines) {
            if ((line = line.trim()).length() > 0) {
                try {
                    if (line.startsWith("PK: ")) {
                        NameProvider.addPackageLine(line);
                    } else if (line.startsWith("CL: ")) {
                        NameProvider.addClassLine(line);
                    } else if (line.startsWith("MD: ")) {
                        NameProvider.addMethodLine(line);
                    } else if (line.startsWith("FD: ")) {
                        NameProvider.addFieldLine(line);
                    } else if (!line.startsWith("#")) {
                        throw new IllegalArgumentException("Invalid line");
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("in file " + f.getName() + " line " + line_number + "\n\t" + (e.getMessage() != null ? e.getMessage() : "") + "\n\t" + line);
                }
            }
            ++line_number;
        }
    }

    private static void addPackageLine(String line) {
        String[] lineParts = line.split(" ");
        if (lineParts.length != 3) {
            throw new IllegalArgumentException("Invalid package line");
        }
        PackageEntry entry = new PackageEntry();
        entry.obfName = lineParts[1].equals(".") ? "" : lineParts[1];
        entry.deobfName = lineParts[2].equals(".") ? "" : lineParts[2];
        PackageEntry oldEntry = packagesObf2Deobf.put(entry.obfName, entry);
        if (oldEntry != null) {
            throw new IllegalArgumentException("Duplicate deobf package with " + oldEntry);
        }
        oldEntry = packagesDeobf2Obf.put(entry.deobfName, entry);
        if (currentMode == 3 && oldEntry != null) {
            throw new IllegalArgumentException("Duplicate reobf package with " + oldEntry);
        }
    }

    private static void addClassLine(String line) {
        String[] lineParts = line.split(" ");
        if (lineParts.length != 3) {
            throw new IllegalArgumentException("Invalid class line");
        }
        ClassEntry entry = new ClassEntry();
        entry.obfName = lineParts[1];
        entry.deobfName = lineParts[2];
        ClassEntry oldEntry = classesObf2Deobf.put(entry.obfName, entry);
        if (oldEntry != null) {
            throw new IllegalArgumentException("Duplicate deobf class with " + oldEntry);
        }
        oldEntry = classesDeobf2Obf.put(entry.deobfName, entry);
        if (currentMode == 3 && oldEntry != null) {
            throw new IllegalArgumentException("Duplicate reobf class with " + oldEntry);
        }
    }

    private static void addMethodLine(String line) {
        String[] lineParts = line.split(" ");
        if (lineParts.length != 5) {
            if (lineParts.length == 4) {
                if (currentMode == 3) {
                    throw new IllegalArgumentException("Missing method descriptor for reobf");
                }
            } else {
                throw new IllegalArgumentException("Invalid method line");
            }
        }
        MethodEntry entry = new MethodEntry();
        entry.obfName = lineParts[1];
        entry.obfDesc = lineParts[2];
        entry.deobfName = lineParts[3];
        entry.deobfDesc = lineParts.length == 5 ? lineParts[4] : lineParts[2];
        try {
            ClassFile.parseMethodDescriptor(entry.obfDesc);
        }
        catch (ClassFileException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        try {
            ClassFile.parseMethodDescriptor(entry.deobfDesc);
        }
        catch (ClassFileException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        MethodEntry oldEntry = methodsObf2Deobf.put(entry.obfName + entry.obfDesc, entry);
        if (oldEntry != null) {
            throw new IllegalArgumentException("Duplicate deobf method with " + oldEntry);
        }
        oldEntry = methodsDeobf2Obf.put(entry.deobfName + entry.deobfDesc, entry);
        if (currentMode == 3 && oldEntry != null) {
            throw new IllegalArgumentException("Duplicate reobf method with " + oldEntry);
        }
    }

    private static void addFieldLine(String line) {
        String[] lineParts = line.split(" ");
        if (lineParts.length != 3) {
            throw new IllegalArgumentException("Invalid field line");
        }
        FieldEntry entry = new FieldEntry();
        entry.obfName = lineParts[1];
        entry.deobfName = lineParts[2];
        FieldEntry oldEntry = fieldsObf2Deobf.put(entry.obfName, entry);
        if (oldEntry != null) {
            throw new IllegalArgumentException("Duplicate deobf field with " + oldEntry);
        }
        oldEntry = fieldsDeobf2Obf.put(entry.deobfName, entry);
        if (currentMode == 3 && oldEntry != null) {
            throw new IllegalArgumentException("Duplicate reobf field with " + oldEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> readAllLines(File file) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        FileReader fileReader = null;
        BufferedReader reader = null;
        try {
            fileReader = new FileReader(file);
            reader = new BufferedReader(fileReader);
            String line = reader.readLine();
            while (line != null) {
                lines.add(line);
                line = reader.readLine();
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (fileReader != null) {
                    fileReader.close();
                }
            }
            catch (IOException e) {}
        }
        return lines;
    }

    public static void log(String text) {
        NameProvider.log(text, false, false);
    }

    public static void errorLog(String text) {
        NameProvider.log(text, true, false);
    }

    public static void verboseLog(String text) {
        NameProvider.log(text, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void log(String text, boolean error, boolean verbose) {
        block23: {
            if (!NameProvider.verbose && verbose) {
                return;
            }
            if (!quiet && !error) {
                System.out.println(text);
            }
            if (error) {
                System.err.println(text);
            }
            File log = null;
            if (currentMode == 2) {
                log = npLog;
            } else if (currentMode == 3) {
                log = roLog;
            }
            if (log == null) {
                return;
            }
            FileWriter fileWriter = null;
            BufferedWriter writer = null;
            fileWriter = new FileWriter(log, true);
            writer = new BufferedWriter(fileWriter);
            writer.write(text);
            writer.newLine();
            writer.flush();
            try {
                if (writer != null) {
                    writer.close();
                }
                if (fileWriter != null) {
                    fileWriter.close();
                }
                break block23;
            }
            catch (IOException e) {}
            break block23;
            catch (IOException e) {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                    if (fileWriter != null) {
                        fileWriter.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                return;
                catch (Throwable throwable) {
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                        if (fileWriter != null) {
                            fileWriter.close();
                        }
                    }
                    catch (IOException e3) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }

    public static void retainFromSRG(ClassTree classTree) {
        block38: {
            block37: {
                if (currentMode == 1) {
                    return;
                }
                if (currentMode == 0) {
                    return;
                }
                for (String pkg : protectedPackages) {
                    try {
                        classTree.retainClass(pkg + "/**", false, true, false, false, false, null, false, 0, 0);
                        classTree.retainMethod(pkg + "/**", "*", false, null, false, 2, 2);
                        classTree.retainField(pkg + "/**", "*", false, null, false, 2, 2);
                    }
                    catch (ClassFileException e) {}
                }
                if (currentMode != 2) break block37;
                for (PackageEntry pkEntry : packagesObf2Deobf.values()) {
                    Pk pk = null;
                    try {
                        pk = classTree.getPk(pkEntry.obfName);
                    }
                    catch (ClassFileException e) {
                        // empty catch block
                    }
                    if (pk == null) {
                        NameProvider.errorLog("# Warning: package " + pkEntry.obfName + " not found in JAR");
                        continue;
                    }
                    pk.setOutput();
                }
                for (ClassEntry clEntry : classesObf2Deobf.values()) {
                    Cl cl = null;
                    try {
                        cl = classTree.getCl(clEntry.obfName);
                    }
                    catch (ClassFileException e) {
                        // empty catch block
                    }
                    if (cl == null) {
                        NameProvider.errorLog("# Warning: class " + clEntry.obfName + " not found in JAR");
                        continue;
                    }
                    cl.setOutput();
                }
                for (MethodEntry mdEntry : methodsObf2Deobf.values()) {
                    TreeItem md = null;
                    try {
                        md = multipass ? (Md)classTree.retainMethodMap(mdEntry.obfName, mdEntry.obfDesc, NameProvider.getShortName(mdEntry.deobfName)) : classTree.getMd(mdEntry.obfName, mdEntry.obfDesc);
                    }
                    catch (ClassFileException e) {
                        // empty catch block
                    }
                    if (md == null) {
                        NameProvider.errorLog("# Warning: method " + mdEntry.obfName + " not found in JAR");
                        continue;
                    }
                    md.setOutput();
                }
                for (FieldEntry fdEntry : fieldsObf2Deobf.values()) {
                    TreeItem fd = null;
                    try {
                        fd = multipass ? (Fd)classTree.retainFieldMap(fdEntry.obfName, NameProvider.getShortName(fdEntry.deobfName)) : classTree.getFd(fdEntry.obfName);
                    }
                    catch (ClassFileException e) {
                        // empty catch block
                    }
                    if (fd == null) {
                        NameProvider.errorLog("# Warning: field " + fdEntry.obfName + " not found in JAR");
                        continue;
                    }
                    fd.setOutput();
                }
                break block38;
            }
            if (currentMode != 3) break block38;
            for (PackageEntry pkEntry : packagesDeobf2Obf.values()) {
                Pk pk = null;
                try {
                    pk = classTree.getPk(pkEntry.deobfName);
                }
                catch (ClassFileException e) {
                    // empty catch block
                }
                if (pk == null) {
                    NameProvider.errorLog("# Warning: package " + pkEntry.deobfName + " not found in JAR");
                    continue;
                }
                pk.setOutput();
            }
            for (ClassEntry clEntry : classesDeobf2Obf.values()) {
                Cl cl = null;
                try {
                    cl = classTree.getCl(clEntry.deobfName);
                }
                catch (ClassFileException e) {
                    // empty catch block
                }
                if (cl == null) {
                    NameProvider.errorLog("# Warning: class " + clEntry.deobfName + " not found in JAR");
                    continue;
                }
                cl.setOutput();
            }
            for (MethodEntry mdEntry : methodsDeobf2Obf.values()) {
                TreeItem md = null;
                try {
                    md = multipass ? (Md)classTree.retainMethodMap(mdEntry.deobfName, mdEntry.deobfDesc, NameProvider.getShortName(mdEntry.obfName)) : classTree.getMd(mdEntry.deobfName, mdEntry.deobfDesc);
                }
                catch (ClassFileException e) {
                    // empty catch block
                }
                if (md == null) {
                    NameProvider.errorLog("# Warning: method " + mdEntry.deobfName + " not found in JAR");
                    continue;
                }
                md.setOutput();
            }
            for (FieldEntry fdEntry : fieldsDeobf2Obf.values()) {
                TreeItem fd = null;
                try {
                    fd = multipass ? (Fd)classTree.retainFieldMap(fdEntry.deobfName, NameProvider.getShortName(fdEntry.obfName)) : classTree.getFd(fdEntry.deobfName);
                }
                catch (ClassFileException e) {
                    // empty catch block
                }
                if (fd == null) {
                    NameProvider.errorLog("# Warning: field " + fdEntry.deobfName + " not found in JAR");
                    continue;
                }
                fd.setOutput();
            }
        }
    }

    public static String getNewTreeItemName(TreeItem ti) {
        if (ti instanceof Pk) {
            return NameProvider.getNewPackageName((Pk)ti);
        }
        if (ti instanceof Cl) {
            return NameProvider.getNewClassName((Cl)ti);
        }
        if (ti instanceof Md) {
            return NameProvider.getNewMethodName((Md)ti);
        }
        if (ti instanceof Fd) {
            return NameProvider.getNewFieldName((Fd)ti);
        }
        NameProvider.errorLog("# Warning: trying to rename unknown type " + ti.getFullInName(true));
        return null;
    }

    public static String getNewPackageName(Pk pk) {
        String packageName = pk.getInName();
        String fullPackageName = pk.getFullInName();
        String newFullPackageName = null;
        String newPackageName = null;
        String repackageName = null;
        if (currentMode == 1) {
            pk.setOutput();
            return null;
        }
        if (currentMode == 0) {
            newPackageName = "p_" + ++uniqueStart + "_" + packageName;
            pk.setOutput();
            return newPackageName;
        }
        if (NameProvider.isInProtectedPackage(fullPackageName)) {
            return null;
        }
        if (currentMode == 2) {
            if (packagesObf2Deobf.containsKey(fullPackageName)) {
                newFullPackageName = NameProvider.packagesObf2Deobf.get((Object)fullPackageName).deobfName;
            }
        } else if (currentMode == 3 && packagesDeobf2Obf.containsKey(fullPackageName)) {
            newFullPackageName = NameProvider.packagesDeobf2Obf.get((Object)fullPackageName).obfName;
        }
        if (newFullPackageName != null) {
            if (fullPackageName.equals("")) {
                newPackageName = newFullPackageName;
                repackageName = newFullPackageName;
            } else {
                newPackageName = NameProvider.getShortName(newFullPackageName);
                if (repackage) {
                    repackageName = newFullPackageName;
                }
            }
            if (packageName.equals(repackageName)) {
                repackageName = null;
            }
            if (repackageName != null) {
                pk.setRepackageName(repackageName);
            }
        }
        pk.setOutput();
        return newPackageName;
    }

    public static String getNewClassName(Cl cl) {
        String className = cl.getInName();
        String fullClassName = cl.getFullInName();
        String newFullClassName = null;
        String newClassName = null;
        String newRepackageName = null;
        if (currentMode == 1) {
            cl.setOutput();
            return null;
        }
        if (currentMode == 0) {
            if (!cl.isInnerClass() || !Character.isDigit(className.charAt(0))) {
                newClassName = "C_" + ++uniqueStart + "_" + className;
            }
            cl.setOutput();
            return newClassName;
        }
        if (NameProvider.isInProtectedPackage(fullClassName)) {
            return null;
        }
        if (currentMode == 2) {
            if (classesObf2Deobf.containsKey(fullClassName)) {
                newFullClassName = NameProvider.classesObf2Deobf.get((Object)fullClassName).deobfName;
            } else if (uniqueStart > 0) {
                if (!cl.isInnerClass() || !Character.isDigit(className.charAt(0))) {
                    newClassName = "C_" + uniqueStart++ + "_" + className;
                }
            } else if (classesObf2Deobf.size() > 0) {
                NameProvider.errorLog("# Warning: unknown class " + className + " in " + cl.getParent().getFullOutName());
            }
        } else if (currentMode == 3 && classesDeobf2Obf.containsKey(fullClassName)) {
            newFullClassName = NameProvider.classesDeobf2Obf.get((Object)fullClassName).obfName;
        }
        if (newFullClassName != null) {
            newClassName = NameProvider.getShortName(newFullClassName);
            if (repackage) {
                newRepackageName = newFullClassName;
            }
            if (fullClassName.equals(newRepackageName)) {
                newRepackageName = null;
            }
            if (newRepackageName != null) {
                cl.setRepackageName(newRepackageName);
            }
        }
        cl.setOutput();
        return newClassName;
    }

    public static String getNewMethodName(Md md) {
        String methodName = md.getInName();
        String methodDescriptor = md.getDescriptor();
        String fullMethodName = md.getFullInName();
        String methodNameKey = fullMethodName + methodDescriptor;
        String newFullMethodName = null;
        String newMethodName = null;
        if (currentMode == 1) {
            md.setOutput();
            return null;
        }
        if (currentMode == 0) {
            newMethodName = "func_" + ++uniqueStart + "_" + methodName;
            md.setOutput();
            return newMethodName;
        }
        if (NameProvider.isInProtectedPackage(fullMethodName)) {
            return null;
        }
        if (currentMode == 2) {
            if (methodsObf2Deobf.containsKey(methodNameKey)) {
                newFullMethodName = NameProvider.methodsObf2Deobf.get((Object)methodNameKey).deobfName;
            } else if (uniqueStart > 0) {
                newMethodName = "func_" + uniqueStart++ + "_" + methodName;
            } else if (md.getParent().isFromScriptMap()) {
                NameProvider.errorLog("# Warning: unknown method " + methodName + " " + methodDescriptor + " in " + md.getParent().getFullOutName());
            }
        } else if (currentMode == 3 && methodsDeobf2Obf.containsKey(methodNameKey)) {
            newFullMethodName = NameProvider.methodsDeobf2Obf.get((Object)methodNameKey).obfName;
        }
        if (newFullMethodName != null) {
            newMethodName = NameProvider.getShortName(newFullMethodName);
        }
        md.setOutput();
        return newMethodName;
    }

    public static String getNewFieldName(Fd fd) {
        String fieldName = fd.getInName();
        String fullFieldName = fd.getFullInName();
        String newFullFieldName = null;
        String newFieldName = null;
        if (currentMode == 1) {
            fd.setOutput();
            return null;
        }
        if (currentMode == 0) {
            newFieldName = "field_" + ++uniqueStart + "_" + fieldName;
            fd.setOutput();
            return newFieldName;
        }
        if (NameProvider.isInProtectedPackage(fullFieldName)) {
            return null;
        }
        if (currentMode == 2) {
            if (fieldsObf2Deobf.containsKey(fullFieldName)) {
                newFullFieldName = NameProvider.fieldsObf2Deobf.get((Object)fullFieldName).deobfName;
            } else if (uniqueStart > 0) {
                newFieldName = "field_" + uniqueStart++ + "_" + fieldName;
            } else if (fd.getParent().isFromScriptMap()) {
                NameProvider.errorLog("# Warning: unknown field " + fieldName + " in " + fd.getParent().getFullOutName());
            }
        } else if (currentMode == 3 && fieldsDeobf2Obf.containsKey(fullFieldName)) {
            newFullFieldName = NameProvider.fieldsDeobf2Obf.get((Object)fullFieldName).obfName;
        }
        if (newFullFieldName != null) {
            newFieldName = NameProvider.getShortName(newFullFieldName);
        }
        fd.setOutput();
        return newFieldName;
    }

    private static boolean isInProtectedPackage(String fullInName) {
        for (String pkg : protectedPackages) {
            if (!fullInName.startsWith(pkg)) continue;
            return true;
        }
        return false;
    }

    private static String getShortName(String name) {
        if (name != null && name.contains("/")) {
            name = name.substring(name.lastIndexOf("/") + 1);
        }
        return name;
    }

    public static void outputPackage(Pk pk) {
        NameProvider.log("PK: " + pk.getFullInName(true) + " " + pk.getFullOutName(true));
    }

    public static void outputClass(Cl cl) {
        NameProvider.log("CL: " + cl.getFullInName(true) + " " + cl.getFullOutName(true));
    }

    public static void outputMethod(Md md) {
        NameProvider.log("MD: " + md.getFullInName(true) + " " + md.getDescriptor() + " " + md.getFullOutName(true) + " " + md.getOutDescriptor());
    }

    public static void outputField(Fd fd) {
        NameProvider.log("FD: " + fd.getFullInName(true) + " " + fd.getFullOutName(true));
    }
}

