#!/usr/bin/python
# -*- coding: utf-8 -*-
"""
Created on Fri Apr  8 16:36:26 2011

@author: MissLil
@version: v0.1
"""

import sys
import re
import shutil
import os
import fnmatch
from optparse import OptionParser


_PACKAGES = ['GL11', 'GL12', 'GL13', 'GL14', 'GL15', 'GL20', 'GL21', 'ARBMultitexture', 'ARBOcclusionQuery',
             'ARBVertexBufferObject', 'ARBShaderObjects']
_CONSTANTS = [
    (
        {
            'GL11': [
                'glBegin',
                'glDrawArrays',
                'glDrawElements',
            ],
        },
        {
            'GL11': {
#                0: 'GL_POINTS',
                1: 'GL_LINES',
                2: 'GL_LINE_LOOP',
                3: 'GL_LINE_STRIP',
                4: 'GL_TRIANGLES',
                5: 'GL_TRIANGLE_STRIP',
                6: 'GL_TRIANGLE_FAN',
                7: 'GL_QUADS',
                8: 'GL_QUAD_STRIP',
                9: 'GL_POLYGON',
                5121: 'GL_UNSIGNED_BYTE',
                5123: 'GL_UNSIGNED_SHORT',
                5125: 'GL_UNSIGNED_INT',
            },
        }
    ),
    (
        {
            'GL11': [
                'glAccum',
            ],
        },
        {
            'GL11': {
                256: 'GL_ACCUM',
                257: 'GL_LOAD',
                258: 'GL_RETURN',
                259: 'GL_MULT',
                260: 'GL_ADD',
            },
        }
    ),
    (
        {
            'GL11': [
                'glBlendFunc',
            ],
        },
        {
            'GL11': {
                0: 'GL_ZERO',
                1: 'GL_ONE',
                768: 'GL_SRC_COLOR',
                769: 'GL_ONE_MINUS_SRC_COLOR',
                770: 'GL_SRC_ALPHA',
                771: 'GL_ONE_MINUS_SRC_ALPHA',
                772: 'GL_DST_ALPHA',
                773: 'GL_ONE_MINUS_DST_ALPHA',
                774: 'GL_DST_COLOR',
                775: 'GL_ONE_MINUS_DST_COLOR',
                776: 'GL_SRC_ALPHA_SATURATE',
                32769: 'GL_CONSTANT_COLOR',
                32770: 'GL_ONE_MINUS_CONSTANT_COLOR',
                32771: 'GL_CONSTANT_ALPHA',
                32772: 'GL_ONE_MINUS_CONSTANT_ALPHA',
            },
        }
    ),
    (
        {
            'GL11': [
                'glAlphaFunc',
                'glBindTexture',
                'glClipPlane',
                'glColorMaterial',
                'glColorPointer',
                'glCopyPixels',
                'glCopyTexImage1D',
                'glCopyTexImage2D',
                'glCopyTexSubImage1D',
                'glCopyTexSubImage2D',
                'glCullFace',
                'glDepthFunc',
                'glDisable',
                'glDisableClientState',
                'glDrawBuffer',
                'glDrawPixels',
                'glEnable',
                'glEnableClientState',
                'glEvalMesh1',
                'glEvalMesh2',
                'glFeedbackBuffer',
                'glFog',
                'glFogf',
                'glFogi',
                'glFrontFace',
                'glGetBoolean',
                'glGetClipPlane',
                'glGetDouble',
                'glGetFloat',
                'glGetInteger',
                'glGetLight',
                'glGetMap',
                'glGetMaterial',
                'glGetPixelMap',
                'glGetPixelMapfv',
                'glGetPixelMapu',
                'glGetPixelMapuiv',
                'glGetPixelMapusv',
                'glGetPointer',
                'glGetString',
                'glGetTexEnv',
                'glGetTexEnvf',
                'glGetTexEnvi',
                'glGetTexGen',
                'glGetTexGend',
                'glGetTexGenf',
                'glGetTexGeni',
                'glGetTexImage',
                'glGetTexLevelParameter',
                'glGetTexLevelParameterf',
                'glGetTexLevelParameteri',
                'glGetTexParameter',
                'glGetTexParameterf',
                'glGetTexParameteri',
                'glHint',
                'glInterleavedArrays',
                'glIsEnabled',
                'glLight',
                'glLightf',
                'glLighti',
                'glLightModel',
                'glLightModelf',
                'glLightModeli',
                'glLogicOp',
                'glMap1d',
                'glMap1f',
                'glMap2d',
                'glMap2f',
                'glMaterial',
                'glMaterialf',
                'glMateriali',
                'glMatrixMode',
                'glNewList',
                'glNormalPointer',
                'glPixelMap',
                'glPixelMapfv',
                'glPixelMapu',
                'glPixelMapuiv',
                'glPixelMapusv',
                'glPixelStoref',
                'glPixelStorei',
                'glPixelTransferf',
                'glPixelTransferi',
                'glPolygonMode',
                'glReadBuffer',
                'glReadPixels',
                'glRenderMode',
                'glShadeModel',
                'glStencilFunc',
                'glStencilOp',
                'glTexCoordPointer',
                'glTexEnv',
                'glTexEnvf',
                'glTexEnvi',
                'glTexGen',
                'glTexGend',
                'glTexGenf',
                'glTexGeni',
                'glTexImage1D',
                'glTexImage2D',
                'glTexParameter',
                'glTexParameterf',
                'glTexParameteri',
                'glTexSubImage1D',
                'glTexSubImage2D',
                'glVertexPointer',
            ],
            'GL12': [
                'glCopyTexSubImage3D',
                'glDrawRangeElements',
                'glTexImage3D',
                'glTexSubImage3D',
            ],
            'GL13': [
                'glActiveTexture',
                'glClientActiveTexture',
                'glCompressedTexImage1D',
                'glCompressedTexImage2D',
                'glCompressedTexImage3D',
                'glCompressedTexSubImage1D',
                'glCompressedTexSubImage2D',
                'glCompressedTexSubImage3D',
                'glGetCompressedTexImage',
                'glMultiTexCoord1d',
                'glMultiTexCoord1f',
                'glMultiTexCoord2d',
                'glMultiTexCoord2f',
                'glMultiTexCoord3d',
                'glMultiTexCoord3f',
                'glMultiTexCoord4d',
                'glMultiTexCoord4f',
            ],
            'GL14': [
                'glBlendEquation',
                'glBlendFuncSeparate',
                'glFogCoordPointer',
                'glMultiDrawArrays',
                'glPointParameter',
                'glPointParameterf',
                'glPointParameteri',
                'glSecondaryColorPointer',
            ],
            'GL15': [
                'glBeginQuery',
                'glBindBuffer',
                'glBufferData',
                'glBufferSubData',
                'glEndQuery',
                'glGetBufferParameter',
                'glGetBufferPointer',
                'glGetBufferSubData',
                'glGetQuery',
                'glGetQueryObject',
                'glGetQueryObjecti',
                'glGetQueryObjectu',
                'glGetQueryObjectui',
                'glMapBuffer',
                'glUnmapBuffer',
            ],
            'GL20': [
                'glBlendEquationSeparate',
                'glCreateShader',
                'glDrawBuffers',
                'glGetActiveAttrib',
                'glGetActiveUniform',
                'glGetProgram',
                'glGetShader',
                'glGetVertexAttrib',
                'glGetVertexAttribPointer',
                'glStencilFuncSeparate',
                'glStencilMaskSeparate',
                'glStencilOpSeparate',
                'glVertexAttribPointer',
            ],
            'ARBMultitexture': [
                'glActiveTextureARB',
                'glClientActiveTextureARB',
                'glMultiTexCoord1dARB',
                'glMultiTexCoord1fARB',
                'glMultiTexCoord1iARB',
                'glMultiTexCoord1sARB',
                'glMultiTexCoord2dARB',
                'glMultiTexCoord2fARB',
                'glMultiTexCoord2iARB',
                'glMultiTexCoord2sARB',
                'glMultiTexCoord3dARB',
                'glMultiTexCoord3fARB',
                'glMultiTexCoord3iARB',
                'glMultiTexCoord3sARB',
                'glMultiTexCoord4dARB',
                'glMultiTexCoord4fARB',
                'glMultiTexCoord4iARB',
                'glMultiTexCoord4sARB',
            ],
            'ARBOcclusionQuery': [
                'glBeginQueryARB',
                'glEndQueryARB',
                'glGetQueryARB',
                'glGetQueryObjectARB',
                'glGetQueryObjectiARB',
                'glGetQueryObjectuARB',
                'glGetQueryObjectuiARB',
            ],
            'ARBVertexBufferObject': [
                'glBindBufferARB',
                'glBufferDataARB',
                'glBufferSubDataARB',
                'glGetBufferParameterARB',
                'glGetBufferPointerARB',
                'glGetBufferSubDataARB',
                'glMapBufferARB',
                'glUnmapBufferARB',
            ],
        },
        {
            'GL11': {
                260: 'GL_ADD',
                512: 'GL_NEVER',
                513: 'GL_LESS',
                514: 'GL_EQUAL',
                515: 'GL_LEQUAL',
                516: 'GL_GREATER',
                517: 'GL_NOTEQUAL',
                518: 'GL_GEQUAL',
                519: 'GL_ALWAYS',
                768: 'GL_SRC_COLOR',
                769: 'GL_ONE_MINUS_SRC_COLOR',
                770: 'GL_SRC_ALPHA',
                771: 'GL_ONE_MINUS_SRC_ALPHA',
                772: 'GL_DST_ALPHA',
                773: 'GL_ONE_MINUS_DST_ALPHA',
                774: 'GL_DST_COLOR',
                775: 'GL_ONE_MINUS_DST_COLOR',
                776: 'GL_SRC_ALPHA_SATURATE',
                1024: 'GL_FRONT_LEFT',
                1025: 'GL_FRONT_RIGHT',
                1026: 'GL_BACK_LEFT',
                1027: 'GL_BACK_RIGHT',
                1028: 'GL_FRONT',
                1029: 'GL_BACK',
                1030: 'GL_LEFT',
                1031: 'GL_RIGHT',
                1032: 'GL_FRONT_AND_BACK',
                1033: 'GL_AUX0',
                1034: 'GL_AUX1',
                1035: 'GL_AUX2',
                1036: 'GL_AUX3',
                1280: 'GL_INVALID_ENUM',
                1281: 'GL_INVALID_VALUE',
                1282: 'GL_INVALID_OPERATION',
                1283: 'GL_STACK_OVERFLOW',
                1284: 'GL_STACK_UNDERFLOW',
                1285: 'GL_OUT_OF_MEMORY',
                1536: 'GL_2D',
                1537: 'GL_3D',
                1538: 'GL_3D_COLOR',
                1539: 'GL_3D_COLOR_TEXTURE',
                1540: 'GL_4D_COLOR_TEXTURE',
                1792: 'GL_PASS_THROUGH_TOKEN',
                1793: 'GL_POINT_TOKEN',
                1794: 'GL_LINE_TOKEN',
                1795: 'GL_POLYGON_TOKEN',
                1796: 'GL_BITMAP_TOKEN',
                1797: 'GL_DRAW_PIXEL_TOKEN',
                1798: 'GL_COPY_PIXEL_TOKEN',
                1799: 'GL_LINE_RESET_TOKEN',
                2048: 'GL_EXP',
                2049: 'GL_EXP2',
                2304: 'GL_CW',
                2305: 'GL_CCW',
                2560: 'GL_COEFF',
                2561: 'GL_ORDER',
                2562: 'GL_DOMAIN',
                2816: 'GL_CURRENT_COLOR',
                2817: 'GL_CURRENT_INDEX',
                2818: 'GL_CURRENT_NORMAL',
                2819: 'GL_CURRENT_TEXTURE_COORDS',
                2820: 'GL_CURRENT_RASTER_COLOR',
                2821: 'GL_CURRENT_RASTER_INDEX',
                2822: 'GL_CURRENT_RASTER_TEXTURE_COORDS',
                2823: 'GL_CURRENT_RASTER_POSITION',
                2824: 'GL_CURRENT_RASTER_POSITION_VALID',
                2825: 'GL_CURRENT_RASTER_DISTANCE',
                2832: 'GL_POINT_SMOOTH',
                2833: 'GL_POINT_SIZE',
                2834: 'GL_POINT_SIZE_RANGE',
                2835: 'GL_POINT_SIZE_GRANULARITY',
                2848: 'GL_LINE_SMOOTH',
                2849: 'GL_LINE_WIDTH',
                2850: 'GL_LINE_WIDTH_RANGE',
                2851: 'GL_LINE_WIDTH_GRANULARITY',
                2852: 'GL_LINE_STIPPLE',
                2853: 'GL_LINE_STIPPLE_PATTERN',
                2854: 'GL_LINE_STIPPLE_REPEAT',
                2864: 'GL_LIST_MODE',
                2865: 'GL_MAX_LIST_NESTING',
                2866: 'GL_LIST_BASE',
                2867: 'GL_LIST_INDEX',
                2880: 'GL_POLYGON_MODE',
                2881: 'GL_POLYGON_SMOOTH',
                2882: 'GL_POLYGON_STIPPLE',
                2883: 'GL_EDGE_FLAG',
                2884: 'GL_CULL_FACE',
                2885: 'GL_CULL_FACE_MODE',
                2886: 'GL_FRONT_FACE',
                2896: 'GL_LIGHTING',
                2897: 'GL_LIGHT_MODEL_LOCAL_VIEWER',
                2898: 'GL_LIGHT_MODEL_TWO_SIDE',
                2899: 'GL_LIGHT_MODEL_AMBIENT',
                2900: 'GL_SHADE_MODEL',
                2901: 'GL_COLOR_MATERIAL_FACE',
                2902: 'GL_COLOR_MATERIAL_PARAMETER',
                2903: 'GL_COLOR_MATERIAL',
                2912: 'GL_FOG',
                2913: 'GL_FOG_INDEX',
                2914: 'GL_FOG_DENSITY',
                2915: 'GL_FOG_START',
                2916: 'GL_FOG_END',
                2917: 'GL_FOG_MODE',
                2918: 'GL_FOG_COLOR',
                2928: 'GL_DEPTH_RANGE',
                2929: 'GL_DEPTH_TEST',
                2930: 'GL_DEPTH_WRITEMASK',
                2931: 'GL_DEPTH_CLEAR_VALUE',
                2932: 'GL_DEPTH_FUNC',
                2944: 'GL_ACCUM_CLEAR_VALUE',
                2960: 'GL_STENCIL_TEST',
                2961: 'GL_STENCIL_CLEAR_VALUE',
                2962: 'GL_STENCIL_FUNC',
                2963: 'GL_STENCIL_VALUE_MASK',
                2964: 'GL_STENCIL_FAIL',
                2965: 'GL_STENCIL_PASS_DEPTH_FAIL',
                2966: 'GL_STENCIL_PASS_DEPTH_PASS',
                2967: 'GL_STENCIL_REF',
                2968: 'GL_STENCIL_WRITEMASK',
                2976: 'GL_MATRIX_MODE',
                2977: 'GL_NORMALIZE',
                2978: 'GL_VIEWPORT',
                2979: 'GL_MODELVIEW_STACK_DEPTH',
                2980: 'GL_PROJECTION_STACK_DEPTH',
                2981: 'GL_TEXTURE_STACK_DEPTH',
                2982: 'GL_MODELVIEW_MATRIX',
                2983: 'GL_PROJECTION_MATRIX',
                2984: 'GL_TEXTURE_MATRIX',
                2992: 'GL_ATTRIB_STACK_DEPTH',
                2993: 'GL_CLIENT_ATTRIB_STACK_DEPTH',
                3008: 'GL_ALPHA_TEST',
                3009: 'GL_ALPHA_TEST_FUNC',
                3010: 'GL_ALPHA_TEST_REF',
                3024: 'GL_DITHER',
                3040: 'GL_BLEND_DST',
                3041: 'GL_BLEND_SRC',
                3042: 'GL_BLEND',
                3056: 'GL_LOGIC_OP_MODE',
                3057: 'GL_INDEX_LOGIC_OP',
                3058: 'GL_COLOR_LOGIC_OP',
                3072: 'GL_AUX_BUFFERS',
                3073: 'GL_DRAW_BUFFER',
                3074: 'GL_READ_BUFFER',
                3088: 'GL_SCISSOR_BOX',
                3089: 'GL_SCISSOR_TEST',
                3104: 'GL_INDEX_CLEAR_VALUE',
                3105: 'GL_INDEX_WRITEMASK',
                3106: 'GL_COLOR_CLEAR_VALUE',
                3107: 'GL_COLOR_WRITEMASK',
                3120: 'GL_INDEX_MODE',
                3121: 'GL_RGBA_MODE',
                3122: 'GL_DOUBLEBUFFER',
                3123: 'GL_STEREO',
                3136: 'GL_RENDER_MODE',
                3152: 'GL_PERSPECTIVE_CORRECTION_HINT',
                3153: 'GL_POINT_SMOOTH_HINT',
                3154: 'GL_LINE_SMOOTH_HINT',
                3155: 'GL_POLYGON_SMOOTH_HINT',
                3156: 'GL_FOG_HINT',
                3168: 'GL_TEXTURE_GEN_S',
                3169: 'GL_TEXTURE_GEN_T',
                3170: 'GL_TEXTURE_GEN_R',
                3171: 'GL_TEXTURE_GEN_Q',
                3184: 'GL_PIXEL_MAP_I_TO_I',
                3185: 'GL_PIXEL_MAP_S_TO_S',
                3186: 'GL_PIXEL_MAP_I_TO_R',
                3187: 'GL_PIXEL_MAP_I_TO_G',
                3188: 'GL_PIXEL_MAP_I_TO_B',
                3189: 'GL_PIXEL_MAP_I_TO_A',
                3190: 'GL_PIXEL_MAP_R_TO_R',
                3191: 'GL_PIXEL_MAP_G_TO_G',
                3192: 'GL_PIXEL_MAP_B_TO_B',
                3193: 'GL_PIXEL_MAP_A_TO_A',
                3248: 'GL_PIXEL_MAP_I_TO_I_SIZE',
                3249: 'GL_PIXEL_MAP_S_TO_S_SIZE',
                3250: 'GL_PIXEL_MAP_I_TO_R_SIZE',
                3251: 'GL_PIXEL_MAP_I_TO_G_SIZE',
                3252: 'GL_PIXEL_MAP_I_TO_B_SIZE',
                3253: 'GL_PIXEL_MAP_I_TO_A_SIZE',
                3254: 'GL_PIXEL_MAP_R_TO_R_SIZE',
                3255: 'GL_PIXEL_MAP_G_TO_G_SIZE',
                3256: 'GL_PIXEL_MAP_B_TO_B_SIZE',
                3257: 'GL_PIXEL_MAP_A_TO_A_SIZE',
                3312: 'GL_UNPACK_SWAP_BYTES',
                3313: 'GL_UNPACK_LSB_FIRST',
                3314: 'GL_UNPACK_ROW_LENGTH',
                3315: 'GL_UNPACK_SKIP_ROWS',
                3316: 'GL_UNPACK_SKIP_PIXELS',
                3317: 'GL_UNPACK_ALIGNMENT',
                3328: 'GL_PACK_SWAP_BYTES',
                3329: 'GL_PACK_LSB_FIRST',
                3330: 'GL_PACK_ROW_LENGTH',
                3331: 'GL_PACK_SKIP_ROWS',
                3332: 'GL_PACK_SKIP_PIXELS',
                3333: 'GL_PACK_ALIGNMENT',
                3344: 'GL_MAP_COLOR',
                3345: 'GL_MAP_STENCIL',
                3346: 'GL_INDEX_SHIFT',
                3347: 'GL_INDEX_OFFSET',
                3348: 'GL_RED_SCALE',
                3349: 'GL_RED_BIAS',
                3350: 'GL_ZOOM_X',
                3351: 'GL_ZOOM_Y',
                3352: 'GL_GREEN_SCALE',
                3353: 'GL_GREEN_BIAS',
                3354: 'GL_BLUE_SCALE',
                3355: 'GL_BLUE_BIAS',
                3356: 'GL_ALPHA_SCALE',
                3357: 'GL_ALPHA_BIAS',
                3358: 'GL_DEPTH_SCALE',
                3359: 'GL_DEPTH_BIAS',
                3376: 'GL_MAX_EVAL_ORDER',
                3377: 'GL_MAX_LIGHTS',
                3378: 'GL_MAX_CLIP_PLANES',
                3379: 'GL_MAX_TEXTURE_SIZE',
                3380: 'GL_MAX_PIXEL_MAP_TABLE',
                3381: 'GL_MAX_ATTRIB_STACK_DEPTH',
                3382: 'GL_MAX_MODELVIEW_STACK_DEPTH',
                3383: 'GL_MAX_NAME_STACK_DEPTH',
                3384: 'GL_MAX_PROJECTION_STACK_DEPTH',
                3385: 'GL_MAX_TEXTURE_STACK_DEPTH',
                3386: 'GL_MAX_VIEWPORT_DIMS',
                3387: 'GL_MAX_CLIENT_ATTRIB_STACK_DEPTH',
                3408: 'GL_SUBPIXEL_BITS',
                3409: 'GL_INDEX_BITS',
                3410: 'GL_RED_BITS',
                3411: 'GL_GREEN_BITS',
                3412: 'GL_BLUE_BITS',
                3413: 'GL_ALPHA_BITS',
                3414: 'GL_DEPTH_BITS',
                3415: 'GL_STENCIL_BITS',
                3416: 'GL_ACCUM_RED_BITS',
                3417: 'GL_ACCUM_GREEN_BITS',
                3418: 'GL_ACCUM_BLUE_BITS',
                3419: 'GL_ACCUM_ALPHA_BITS',
                3440: 'GL_NAME_STACK_DEPTH',
                3456: 'GL_AUTO_NORMAL',
                3472: 'GL_MAP1_COLOR_4',
                3473: 'GL_MAP1_INDEX',
                3474: 'GL_MAP1_NORMAL',
                3475: 'GL_MAP1_TEXTURE_COORD_1',
                3476: 'GL_MAP1_TEXTURE_COORD_2',
                3477: 'GL_MAP1_TEXTURE_COORD_3',
                3478: 'GL_MAP1_TEXTURE_COORD_4',
                3479: 'GL_MAP1_VERTEX_3',
                3480: 'GL_MAP1_VERTEX_4',
                3504: 'GL_MAP2_COLOR_4',
                3505: 'GL_MAP2_INDEX',
                3506: 'GL_MAP2_NORMAL',
                3507: 'GL_MAP2_TEXTURE_COORD_1',
                3508: 'GL_MAP2_TEXTURE_COORD_2',
                3509: 'GL_MAP2_TEXTURE_COORD_3',
                3510: 'GL_MAP2_TEXTURE_COORD_4',
                3511: 'GL_MAP2_VERTEX_3',
                3512: 'GL_MAP2_VERTEX_4',
                3536: 'GL_MAP1_GRID_DOMAIN',
                3537: 'GL_MAP1_GRID_SEGMENTS',
                3538: 'GL_MAP2_GRID_DOMAIN',
                3539: 'GL_MAP2_GRID_SEGMENTS',
                3552: 'GL_TEXTURE_1D',
                3553: 'GL_TEXTURE_2D',
                3568: 'GL_FEEDBACK_BUFFER_POINTER',
                3569: 'GL_FEEDBACK_BUFFER_SIZE',
                3570: 'GL_FEEDBACK_BUFFER_TYPE',
                3571: 'GL_SELECTION_BUFFER_POINTER',
                3572: 'GL_SELECTION_BUFFER_SIZE',
                4096: 'GL_TEXTURE_WIDTH',
                4097: 'GL_TEXTURE_HEIGHT',
                4099: 'GL_TEXTURE_INTERNAL_FORMAT',
                4100: 'GL_TEXTURE_BORDER_COLOR',
                4101: 'GL_TEXTURE_BORDER',
                4352: 'GL_DONT_CARE',
                4353: 'GL_FASTEST',
                4354: 'GL_NICEST',
                4608: 'GL_AMBIENT',
                4609: 'GL_DIFFUSE',
                4610: 'GL_SPECULAR',
                4611: 'GL_POSITION',
                4612: 'GL_SPOT_DIRECTION',
                4613: 'GL_SPOT_EXPONENT',
                4614: 'GL_SPOT_CUTOFF',
                4615: 'GL_CONSTANT_ATTENUATION',
                4616: 'GL_LINEAR_ATTENUATION',
                4617: 'GL_QUADRATIC_ATTENUATION',
                4864: 'GL_COMPILE',
                4865: 'GL_COMPILE_AND_EXECUTE',
                5120: 'GL_BYTE',
                5121: 'GL_UNSIGNED_BYTE',
                5122: 'GL_SHORT',
                5123: 'GL_UNSIGNED_SHORT',
                5124: 'GL_INT',
                5125: 'GL_UNSIGNED_INT',
                5126: 'GL_FLOAT',
                5127: 'GL_2_BYTES',
                5128: 'GL_3_BYTES',
                5129: 'GL_4_BYTES',
                5130: 'GL_DOUBLE',
                5376: 'GL_CLEAR',
                5377: 'GL_AND',
                5378: 'GL_AND_REVERSE',
                5379: 'GL_COPY',
                5380: 'GL_AND_INVERTED',
                5381: 'GL_NOOP',
                5382: 'GL_XOR',
                5383: 'GL_OR',
                5384: 'GL_NOR',
                5385: 'GL_EQUIV',
                5386: 'GL_INVERT',
                5387: 'GL_OR_REVERSE',
                5388: 'GL_COPY_INVERTED',
                5389: 'GL_OR_INVERTED',
                5390: 'GL_NAND',
                5391: 'GL_SET',
                5632: 'GL_EMISSION',
                5633: 'GL_SHININESS',
                5634: 'GL_AMBIENT_AND_DIFFUSE',
                5635: 'GL_COLOR_INDEXES',
                5888: 'GL_MODELVIEW',
                5889: 'GL_PROJECTION',
                5890: 'GL_TEXTURE',
                6144: 'GL_COLOR',
                6145: 'GL_DEPTH',
                6146: 'GL_STENCIL',
                6400: 'GL_COLOR_INDEX',
                6401: 'GL_STENCIL_INDEX',
                6402: 'GL_DEPTH_COMPONENT',
                6403: 'GL_RED',
                6404: 'GL_GREEN',
                6405: 'GL_BLUE',
                6406: 'GL_ALPHA',
                6407: 'GL_RGB',
                6408: 'GL_RGBA',
                6409: 'GL_LUMINANCE',
                6410: 'GL_LUMINANCE_ALPHA',
                6656: 'GL_BITMAP',
                6912: 'GL_POINT',
                6913: 'GL_LINE',
                6914: 'GL_FILL',
                7168: 'GL_RENDER',
                7169: 'GL_FEEDBACK',
                7170: 'GL_SELECT',
                7424: 'GL_FLAT',
                7425: 'GL_SMOOTH',
                7680: 'GL_KEEP',
                7681: 'GL_REPLACE',
                7682: 'GL_INCR',
                7683: 'GL_DECR',
                7936: 'GL_VENDOR',
                7937: 'GL_RENDERER',
                7938: 'GL_VERSION',
                7939: 'GL_EXTENSIONS',
                8192: 'GL_S',
                8193: 'GL_T',
                8194: 'GL_R',
                8195: 'GL_Q',
                8448: 'GL_MODULATE',
                8449: 'GL_DECAL',
                8704: 'GL_TEXTURE_ENV_MODE',
                8705: 'GL_TEXTURE_ENV_COLOR',
                8960: 'GL_TEXTURE_ENV',
                9216: 'GL_EYE_LINEAR',
                9217: 'GL_OBJECT_LINEAR',
                9218: 'GL_SPHERE_MAP',
                9472: 'GL_TEXTURE_GEN_MODE',
                9473: 'GL_OBJECT_PLANE',
                9474: 'GL_EYE_PLANE',
                9728: 'GL_NEAREST',
                9729: 'GL_LINEAR',
                9984: 'GL_NEAREST_MIPMAP_NEAREST',
                9985: 'GL_LINEAR_MIPMAP_NEAREST',
                9986: 'GL_NEAREST_MIPMAP_LINEAR',
                9987: 'GL_LINEAR_MIPMAP_LINEAR',
                10240: 'GL_TEXTURE_MAG_FILTER',
                10241: 'GL_TEXTURE_MIN_FILTER',
                10242: 'GL_TEXTURE_WRAP_S',
                10243: 'GL_TEXTURE_WRAP_T',
                10496: 'GL_CLAMP',
                10497: 'GL_REPEAT',
                10752: 'GL_POLYGON_OFFSET_UNITS',
                10753: 'GL_POLYGON_OFFSET_POINT',
                10754: 'GL_POLYGON_OFFSET_LINE',
                10768: 'GL_R3_G3_B2',
                10784: 'GL_V2F',
                10785: 'GL_V3F',
                10786: 'GL_C4UB_V2F',
                10787: 'GL_C4UB_V3F',
                10788: 'GL_C3F_V3F',
                10789: 'GL_N3F_V3F',
                10790: 'GL_C4F_N3F_V3F',
                10791: 'GL_T2F_V3F',
                10792: 'GL_T4F_V4F',
                10793: 'GL_T2F_C4UB_V3F',
                10794: 'GL_T2F_C3F_V3F',
                10795: 'GL_T2F_N3F_V3F',
                10796: 'GL_T2F_C4F_N3F_V3F',
                10797: 'GL_T4F_C4F_N3F_V4F',
                12288: 'GL_CLIP_PLANE0',
                12289: 'GL_CLIP_PLANE1',
                12290: 'GL_CLIP_PLANE2',
                12291: 'GL_CLIP_PLANE3',
                12292: 'GL_CLIP_PLANE4',
                12293: 'GL_CLIP_PLANE5',
                16384: 'GL_LIGHT0',
                16385: 'GL_LIGHT1',
                16386: 'GL_LIGHT2',
                16387: 'GL_LIGHT3',
                16388: 'GL_LIGHT4',
                16389: 'GL_LIGHT5',
                16390: 'GL_LIGHT6',
                16391: 'GL_LIGHT7',
                32769: 'GL_CONSTANT_COLOR',
                32770: 'GL_ONE_MINUS_CONSTANT_COLOR',
                32771: 'GL_CONSTANT_ALPHA',
                32772: 'GL_ONE_MINUS_CONSTANT_ALPHA',
                32823: 'GL_POLYGON_OFFSET_FILL',
                32824: 'GL_POLYGON_OFFSET_FACTOR',
                32827: 'GL_ALPHA4',
                32828: 'GL_ALPHA8',
                32829: 'GL_ALPHA12',
                32830: 'GL_ALPHA16',
                32831: 'GL_LUMINANCE4',
                32832: 'GL_LUMINANCE8',
                32833: 'GL_LUMINANCE12',
                32834: 'GL_LUMINANCE16',
                32835: 'GL_LUMINANCE4_ALPHA4',
                32836: 'GL_LUMINANCE6_ALPHA2',
                32837: 'GL_LUMINANCE8_ALPHA8',
                32838: 'GL_LUMINANCE12_ALPHA4',
                32839: 'GL_LUMINANCE12_ALPHA12',
                32840: 'GL_LUMINANCE16_ALPHA16',
                32841: 'GL_INTENSITY',
                32842: 'GL_INTENSITY4',
                32843: 'GL_INTENSITY8',
                32844: 'GL_INTENSITY12',
                32845: 'GL_INTENSITY16',
                32847: 'GL_RGB4',
                32848: 'GL_RGB5',
                32849: 'GL_RGB8',
                32850: 'GL_RGB10',
                32851: 'GL_RGB12',
                32852: 'GL_RGB16',
                32853: 'GL_RGBA2',
                32854: 'GL_RGBA4',
                32855: 'GL_RGB5_A1',
                32856: 'GL_RGBA8',
                32857: 'GL_RGB10_A2',
                32858: 'GL_RGBA12',
                32859: 'GL_RGBA16',
                32860: 'GL_TEXTURE_RED_SIZE',
                32861: 'GL_TEXTURE_GREEN_SIZE',
                32862: 'GL_TEXTURE_BLUE_SIZE',
                32863: 'GL_TEXTURE_ALPHA_SIZE',
                32864: 'GL_TEXTURE_LUMINANCE_SIZE',
                32865: 'GL_TEXTURE_INTENSITY_SIZE',
                32867: 'GL_PROXY_TEXTURE_1D',
                32868: 'GL_PROXY_TEXTURE_2D',
                32870: 'GL_TEXTURE_PRIORITY',
                32871: 'GL_TEXTURE_RESIDENT',
                32872: 'GL_TEXTURE_BINDING_1D',
                32873: 'GL_TEXTURE_BINDING_2D',
                32884: 'GL_VERTEX_ARRAY',
                32885: 'GL_NORMAL_ARRAY',
                32886: 'GL_COLOR_ARRAY',
                32887: 'GL_INDEX_ARRAY',
                32888: 'GL_TEXTURE_COORD_ARRAY',
                32889: 'GL_EDGE_FLAG_ARRAY',
                32890: 'GL_VERTEX_ARRAY_SIZE',
                32891: 'GL_VERTEX_ARRAY_TYPE',
                32892: 'GL_VERTEX_ARRAY_STRIDE',
                32894: 'GL_NORMAL_ARRAY_TYPE',
                32895: 'GL_NORMAL_ARRAY_STRIDE',
                32897: 'GL_COLOR_ARRAY_SIZE',
                32898: 'GL_COLOR_ARRAY_TYPE',
                32899: 'GL_COLOR_ARRAY_STRIDE',
                32901: 'GL_INDEX_ARRAY_TYPE',
                32902: 'GL_INDEX_ARRAY_STRIDE',
                32904: 'GL_TEXTURE_COORD_ARRAY_SIZE',
                32905: 'GL_TEXTURE_COORD_ARRAY_TYPE',
                32906: 'GL_TEXTURE_COORD_ARRAY_STRIDE',
                32908: 'GL_EDGE_FLAG_ARRAY_STRIDE',
                32910: 'GL_VERTEX_ARRAY_POINTER',
                32911: 'GL_NORMAL_ARRAY_POINTER',
                32912: 'GL_COLOR_ARRAY_POINTER',
                32913: 'GL_INDEX_ARRAY_POINTER',
                32914: 'GL_TEXTURE_COORD_ARRAY_POINTER',
                32915: 'GL_EDGE_FLAG_ARRAY_POINTER',
            },
            'GL12': {
                2834: 'GL_SMOOTH_POINT_SIZE_RANGE',
                2835: 'GL_SMOOTH_POINT_SIZE_GRANULARITY',
                2850: 'GL_SMOOTH_LINE_WIDTH_RANGE',
                2851: 'GL_SMOOTH_LINE_WIDTH_GRANULARITY',
                32818: 'GL_UNSIGNED_BYTE_3_3_2',
                32819: 'GL_UNSIGNED_SHORT_4_4_4_4',
                32820: 'GL_UNSIGNED_SHORT_5_5_5_1',
                32821: 'GL_UNSIGNED_INT_8_8_8_8',
                32822: 'GL_UNSIGNED_INT_10_10_10_2',
                32826: 'GL_RESCALE_NORMAL',
                32874: 'GL_TEXTURE_BINDING_3D',
                32875: 'GL_PACK_SKIP_IMAGES',
                32876: 'GL_PACK_IMAGE_HEIGHT',
                32877: 'GL_UNPACK_SKIP_IMAGES',
                32878: 'GL_UNPACK_IMAGE_HEIGHT',
                32879: 'GL_TEXTURE_3D',
                32880: 'GL_PROXY_TEXTURE_3D',
                32881: 'GL_TEXTURE_DEPTH',
                32882: 'GL_TEXTURE_WRAP_R',
                32883: 'GL_MAX_3D_TEXTURE_SIZE',
                32992: 'GL_BGR',
                32993: 'GL_BGRA',
                33000: 'GL_MAX_ELEMENTS_VERTICES',
                33001: 'GL_MAX_ELEMENTS_INDICES',
                33071: 'GL_CLAMP_TO_EDGE',
                33082: 'GL_TEXTURE_MIN_LOD',
                33083: 'GL_TEXTURE_MAX_LOD',
                33084: 'GL_TEXTURE_BASE_LEVEL',
                33085: 'GL_TEXTURE_MAX_LEVEL',
                33272: 'GL_LIGHT_MODEL_COLOR_CONTROL',
                33273: 'GL_SINGLE_COLOR',
                33274: 'GL_SEPARATE_SPECULAR_COLOR',
                33634: 'GL_UNSIGNED_BYTE_2_3_3_REV',
                33635: 'GL_UNSIGNED_SHORT_5_6_5',
                33636: 'GL_UNSIGNED_SHORT_5_6_5_REV',
                33637: 'GL_UNSIGNED_SHORT_4_4_4_4_REV',
                33638: 'GL_UNSIGNED_SHORT_1_5_5_5_REV',
                33639: 'GL_UNSIGNED_INT_8_8_8_8_REV',
                33640: 'GL_UNSIGNED_INT_2_10_10_10_REV',
                33901: 'GL_ALIASED_POINT_SIZE_RANGE',
                33902: 'GL_ALIASED_LINE_WIDTH_RANGE',
            },
            'GL13': {
                32925: 'GL_MULTISAMPLE',
                32926: 'GL_SAMPLE_ALPHA_TO_COVERAGE',
                32927: 'GL_SAMPLE_ALPHA_TO_ONE',
                32928: 'GL_SAMPLE_COVERAGE',
                32936: 'GL_SAMPLE_BUFFERS',
                32937: 'GL_SAMPLES',
                32938: 'GL_SAMPLE_COVERAGE_VALUE',
                32939: 'GL_SAMPLE_COVERAGE_INVERT',
                33069: 'GL_CLAMP_TO_BORDER',
                33984: 'GL_TEXTURE0',
                33985: 'GL_TEXTURE1',
                33986: 'GL_TEXTURE2',
                33987: 'GL_TEXTURE3',
                33988: 'GL_TEXTURE4',
                33989: 'GL_TEXTURE5',
                33990: 'GL_TEXTURE6',
                33991: 'GL_TEXTURE7',
                33992: 'GL_TEXTURE8',
                33993: 'GL_TEXTURE9',
                33994: 'GL_TEXTURE10',
                33995: 'GL_TEXTURE11',
                33996: 'GL_TEXTURE12',
                33997: 'GL_TEXTURE13',
                33998: 'GL_TEXTURE14',
                33999: 'GL_TEXTURE15',
                34000: 'GL_TEXTURE16',
                34001: 'GL_TEXTURE17',
                34002: 'GL_TEXTURE18',
                34003: 'GL_TEXTURE19',
                34004: 'GL_TEXTURE20',
                34005: 'GL_TEXTURE21',
                34006: 'GL_TEXTURE22',
                34007: 'GL_TEXTURE23',
                34008: 'GL_TEXTURE24',
                34009: 'GL_TEXTURE25',
                34010: 'GL_TEXTURE26',
                34011: 'GL_TEXTURE27',
                34012: 'GL_TEXTURE28',
                34013: 'GL_TEXTURE29',
                34014: 'GL_TEXTURE30',
                34015: 'GL_TEXTURE31',
                34016: 'GL_ACTIVE_TEXTURE',
                34017: 'GL_CLIENT_ACTIVE_TEXTURE',
                34018: 'GL_MAX_TEXTURE_UNITS',
                34019: 'GL_TRANSPOSE_MODELVIEW_MATRIX',
                34020: 'GL_TRANSPOSE_PROJECTION_MATRIX',
                34021: 'GL_TRANSPOSE_TEXTURE_MATRIX',
                34022: 'GL_TRANSPOSE_COLOR_MATRIX',
                34023: 'GL_SUBTRACT',
                34025: 'GL_COMPRESSED_ALPHA',
                34026: 'GL_COMPRESSED_LUMINANCE',
                34027: 'GL_COMPRESSED_LUMINANCE_ALPHA',
                34028: 'GL_COMPRESSED_INTENSITY',
                34029: 'GL_COMPRESSED_RGB',
                34030: 'GL_COMPRESSED_RGBA',
                34031: 'GL_TEXTURE_COMPRESSION_HINT',
                34065: 'GL_NORMAL_MAP',
                34066: 'GL_REFLECTION_MAP',
                34067: 'GL_TEXTURE_CUBE_MAP',
                34068: 'GL_TEXTURE_BINDING_CUBE_MAP',
                34069: 'GL_TEXTURE_CUBE_MAP_POSITIVE_X',
                34070: 'GL_TEXTURE_CUBE_MAP_NEGATIVE_X',
                34071: 'GL_TEXTURE_CUBE_MAP_POSITIVE_Y',
                34072: 'GL_TEXTURE_CUBE_MAP_NEGATIVE_Y',
                34073: 'GL_TEXTURE_CUBE_MAP_POSITIVE_Z',
                34074: 'GL_TEXTURE_CUBE_MAP_NEGATIVE_Z',
                34075: 'GL_PROXY_TEXTURE_CUBE_MAP',
                34076: 'GL_MAX_CUBE_MAP_TEXTURE_SIZE',
                34160: 'GL_COMBINE',
                34161: 'GL_COMBINE_RGB',
                34162: 'GL_COMBINE_ALPHA',
                34163: 'GL_RGB_SCALE',
                34164: 'GL_ADD_SIGNED',
                34165: 'GL_INTERPOLATE',
                34166: 'GL_CONSTANT',
                34167: 'GL_PRIMARY_COLOR',
                34168: 'GL_PREVIOUS',
                34176: 'GL_SOURCE0_RGB',
                34177: 'GL_SOURCE1_RGB',
                34178: 'GL_SOURCE2_RGB',
                34184: 'GL_SOURCE0_ALPHA',
                34185: 'GL_SOURCE1_ALPHA',
                34186: 'GL_SOURCE2_ALPHA',
                34192: 'GL_OPERAND0_RGB',
                34193: 'GL_OPERAND1_RGB',
                34194: 'GL_OPERAND2_RGB',
                34200: 'GL_OPERAND0_ALPHA',
                34201: 'GL_OPERAND1_ALPHA',
                34202: 'GL_OPERAND2_ALPHA',
                34464: 'GL_TEXTURE_COMPRESSED_IMAGE_SIZE',
                34465: 'GL_TEXTURE_COMPRESSED',
                34466: 'GL_NUM_COMPRESSED_TEXTURE_FORMATS',
                34467: 'GL_COMPRESSED_TEXTURE_FORMATS',
                34478: 'GL_DOT3_RGB',
                34479: 'GL_DOT3_RGBA',
            },
            'GL14': {
                32773: 'GL_BLEND_COLOR',
                32774: 'GL_FUNC_ADD',
                32775: 'GL_MIN',
                32776: 'GL_MAX',
                32777: 'GL_BLEND_EQUATION',
                32778: 'GL_FUNC_SUBTRACT',
                32779: 'GL_FUNC_REVERSE_SUBTRACT',
                32968: 'GL_BLEND_DST_RGB',
                32969: 'GL_BLEND_SRC_RGB',
                32970: 'GL_BLEND_DST_ALPHA',
                32971: 'GL_BLEND_SRC_ALPHA',
                33062: 'GL_POINT_SIZE_MIN',
                33063: 'GL_POINT_SIZE_MAX',
                33064: 'GL_POINT_FADE_THRESHOLD_SIZE',
                33065: 'GL_POINT_DISTANCE_ATTENUATION',
                33169: 'GL_GENERATE_MIPMAP',
                33170: 'GL_GENERATE_MIPMAP_HINT',
                33189: 'GL_DEPTH_COMPONENT16',
                33190: 'GL_DEPTH_COMPONENT24',
                33191: 'GL_DEPTH_COMPONENT32',
                33648: 'GL_MIRRORED_REPEAT',
                33872: 'GL_FOG_COORDINATE_SOURCE',
                33873: 'GL_FOG_COORDINATE',
                33874: 'GL_FRAGMENT_DEPTH',
                33875: 'GL_CURRENT_FOG_COORDINATE',
                33876: 'GL_FOG_COORDINATE_ARRAY_TYPE',
                33877: 'GL_FOG_COORDINATE_ARRAY_STRIDE',
                33878: 'GL_FOG_COORDINATE_ARRAY_POINTER',
                33879: 'GL_FOG_COORDINATE_ARRAY',
                33880: 'GL_COLOR_SUM',
                33881: 'GL_CURRENT_SECONDARY_COLOR',
                33882: 'GL_SECONDARY_COLOR_ARRAY_SIZE',
                33883: 'GL_SECONDARY_COLOR_ARRAY_TYPE',
                33884: 'GL_SECONDARY_COLOR_ARRAY_STRIDE',
                33885: 'GL_SECONDARY_COLOR_ARRAY_POINTER',
                33886: 'GL_SECONDARY_COLOR_ARRAY',
                34045: 'GL_MAX_TEXTURE_LOD_BIAS',
                34048: 'GL_TEXTURE_FILTER_CONTROL',
                34049: 'GL_TEXTURE_LOD_BIAS',
                34055: 'GL_INCR_WRAP',
                34056: 'GL_DECR_WRAP',
                34890: 'GL_TEXTURE_DEPTH_SIZE',
                34891: 'GL_DEPTH_TEXTURE_MODE',
                34892: 'GL_TEXTURE_COMPARE_MODE',
                34893: 'GL_TEXTURE_COMPARE_FUNC',
                34894: 'GL_COMPARE_R_TO_TEXTURE',
            },
            'GL15': {
                33872: 'GL_FOG_COORD_SRC',
                33873: 'GL_FOG_COORD',
                33875: 'GL_CURRENT_FOG_COORD',
                33876: 'GL_FOG_COORD_ARRAY_TYPE',
                33877: 'GL_FOG_COORD_ARRAY_STRIDE',
                33878: 'GL_FOG_COORD_ARRAY_POINTER',
                33879: 'GL_FOG_COORD_ARRAY',
                34176: 'GL_SRC0_RGB',
                34177: 'GL_SRC1_RGB',
                34178: 'GL_SRC2_RGB',
                34184: 'GL_SRC0_ALPHA',
                34185: 'GL_SRC1_ALPHA',
                34186: 'GL_SRC2_ALPHA',
                34660: 'GL_BUFFER_SIZE',
                34661: 'GL_BUFFER_USAGE',
                34916: 'GL_QUERY_COUNTER_BITS',
                34917: 'GL_CURRENT_QUERY',
                34918: 'GL_QUERY_RESULT',
                34919: 'GL_QUERY_RESULT_AVAILABLE',
                34962: 'GL_ARRAY_BUFFER',
                34963: 'GL_ELEMENT_ARRAY_BUFFER',
                34964: 'GL_ARRAY_BUFFER_BINDING',
                34965: 'GL_ELEMENT_ARRAY_BUFFER_BINDING',
                34966: 'GL_VERTEX_ARRAY_BUFFER_BINDING',
                34967: 'GL_NORMAL_ARRAY_BUFFER_BINDING',
                34968: 'GL_COLOR_ARRAY_BUFFER_BINDING',
                34969: 'GL_INDEX_ARRAY_BUFFER_BINDING',
                34970: 'GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING',
                34971: 'GL_EDGE_FLAG_ARRAY_BUFFER_BINDING',
                34972: 'GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING',
                34973: 'GL_FOG_COORD_ARRAY_BUFFER_BINDING',
                34974: 'GL_WEIGHT_ARRAY_BUFFER_BINDING',
                34975: 'GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING',
                35000: 'GL_READ_ONLY',
                35001: 'GL_WRITE_ONLY',
                35002: 'GL_READ_WRITE',
                35003: 'GL_BUFFER_ACCESS',
                35004: 'GL_BUFFER_MAPPED',
                35005: 'GL_BUFFER_MAP_POINTER',
                35040: 'GL_STREAM_DRAW',
                35041: 'GL_STREAM_READ',
                35042: 'GL_STREAM_COPY',
                35044: 'GL_STATIC_DRAW',
                35045: 'GL_STATIC_READ',
                35046: 'GL_STATIC_COPY',
                35048: 'GL_DYNAMIC_DRAW',
                35049: 'GL_DYNAMIC_READ',
                35050: 'GL_DYNAMIC_COPY',
                35092: 'GL_SAMPLES_PASSED',
            },
            'GL20': {
                32777: 'GL_BLEND_EQUATION_RGB',
                34338: 'GL_VERTEX_ATTRIB_ARRAY_ENABLED',
                34339: 'GL_VERTEX_ATTRIB_ARRAY_SIZE',
                34340: 'GL_VERTEX_ATTRIB_ARRAY_STRIDE',
                34341: 'GL_VERTEX_ATTRIB_ARRAY_TYPE',
                34342: 'GL_CURRENT_VERTEX_ATTRIB',
                34370: 'GL_VERTEX_PROGRAM_POINT_SIZE',
                34371: 'GL_VERTEX_PROGRAM_TWO_SIDE',
                34373: 'GL_VERTEX_ATTRIB_ARRAY_POINTER',
                34816: 'GL_STENCIL_BACK_FUNC',
                34817: 'GL_STENCIL_BACK_FAIL',
                34818: 'GL_STENCIL_BACK_PASS_DEPTH_FAIL',
                34819: 'GL_STENCIL_BACK_PASS_DEPTH_PASS',
                34852: 'GL_MAX_DRAW_BUFFERS',
                34853: 'GL_DRAW_BUFFER0',
                34854: 'GL_DRAW_BUFFER1',
                34855: 'GL_DRAW_BUFFER2',
                34856: 'GL_DRAW_BUFFER3',
                34857: 'GL_DRAW_BUFFER4',
                34858: 'GL_DRAW_BUFFER5',
                34859: 'GL_DRAW_BUFFER6',
                34860: 'GL_DRAW_BUFFER7',
                34861: 'GL_DRAW_BUFFER8',
                34862: 'GL_DRAW_BUFFER9',
                34863: 'GL_DRAW_BUFFER10',
                34864: 'GL_DRAW_BUFFER11',
                34865: 'GL_DRAW_BUFFER12',
                34866: 'GL_DRAW_BUFFER13',
                34867: 'GL_DRAW_BUFFER14',
                34868: 'GL_DRAW_BUFFER15',
                34877: 'GL_BLEND_EQUATION_ALPHA',
                34913: 'GL_POINT_SPRITE',
                34914: 'GL_COORD_REPLACE',
                34921: 'GL_MAX_VERTEX_ATTRIBS',
                34922: 'GL_VERTEX_ATTRIB_ARRAY_NORMALIZED',
                34929: 'GL_MAX_TEXTURE_COORDS',
                34930: 'GL_MAX_TEXTURE_IMAGE_UNITS',
                35632: 'GL_FRAGMENT_SHADER',
                35633: 'GL_VERTEX_SHADER',
                35656: 'GL_SHADER_OBJECT',
                35657: 'GL_MAX_FRAGMENT_UNIFORM_COMPONENTS',
                35658: 'GL_MAX_VERTEX_UNIFORM_COMPONENTS',
                35659: 'GL_MAX_VARYING_FLOATS',
                35660: 'GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS',
                35661: 'GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS',
                35663: 'GL_SHADER_TYPE',
                35664: 'GL_FLOAT_VEC2',
                35665: 'GL_FLOAT_VEC3',
                35666: 'GL_FLOAT_VEC4',
                35667: 'GL_INT_VEC2',
                35668: 'GL_INT_VEC3',
                35669: 'GL_INT_VEC4',
                35670: 'GL_BOOL',
                35671: 'GL_BOOL_VEC2',
                35672: 'GL_BOOL_VEC3',
                35673: 'GL_BOOL_VEC4',
                35674: 'GL_FLOAT_MAT2',
                35675: 'GL_FLOAT_MAT3',
                35676: 'GL_FLOAT_MAT4',
                35677: 'GL_SAMPLER_1D',
                35678: 'GL_SAMPLER_2D',
                35679: 'GL_SAMPLER_3D',
                35680: 'GL_SAMPLER_CUBE',
                35681: 'GL_SAMPLER_1D_SHADOW',
                35682: 'GL_SAMPLER_2D_SHADOW',
                35712: 'GL_DELETE_STATUS',
                35713: 'GL_COMPILE_STATUS',
                35714: 'GL_LINK_STATUS',
                35715: 'GL_VALIDATE_STATUS',
                35716: 'GL_INFO_LOG_LENGTH',
                35717: 'GL_ATTACHED_SHADERS',
                35718: 'GL_ACTIVE_UNIFORMS',
                35719: 'GL_ACTIVE_UNIFORM_MAX_LENGTH',
                35720: 'GL_SHADER_SOURCE_LENGTH',
                35721: 'GL_ACTIVE_ATTRIBUTES',
                35722: 'GL_ACTIVE_ATTRIBUTE_MAX_LENGTH',
                35723: 'GL_FRAGMENT_SHADER_DERIVATIVE_HINT',
                35724: 'GL_SHADING_LANGUAGE_VERSION',
                35725: 'GL_CURRENT_PROGRAM',
                36000: 'GL_POINT_SPRITE_COORD_ORIGIN',
                36001: 'GL_LOWER_LEFT',
                36002: 'GL_UPPER_LEFT',
                36003: 'GL_STENCIL_BACK_REF',
                36004: 'GL_STENCIL_BACK_VALUE_MASK',
                36005: 'GL_STENCIL_BACK_WRITEMASK',
            },
            'GL21': {
                33887: 'GL_CURRENT_RASTER_SECONDARY_COLOR',
                35051: 'GL_PIXEL_PACK_BUFFER',
                35052: 'GL_PIXEL_UNPACK_BUFFER',
                35053: 'GL_PIXEL_PACK_BUFFER_BINDING',
                35055: 'GL_PIXEL_UNPACK_BUFFER_BINDING',
                35685: 'GL_FLOAT_MAT2x3',
                35686: 'GL_FLOAT_MAT2x4',
                35687: 'GL_FLOAT_MAT3x2',
                35688: 'GL_FLOAT_MAT3x4',
                35689: 'GL_FLOAT_MAT4x2',
                35690: 'GL_FLOAT_MAT4x3',
                35904: 'GL_SRGB',
                35905: 'GL_SRGB8',
                35906: 'GL_SRGB_ALPHA',
                35907: 'GL_SRGB8_ALPHA8',
                35908: 'GL_SLUMINANCE_ALPHA',
                35909: 'GL_SLUMINANCE8_ALPHA8',
                35910: 'GL_SLUMINANCE',
                35911: 'GL_SLUMINANCE8',
                35912: 'GL_COMPRESSED_SRGB',
                35913: 'GL_COMPRESSED_SRGB_ALPHA',
                35914: 'GL_COMPRESSED_SLUMINANCE',
                35915: 'GL_COMPRESSED_SLUMINANCE_ALPHA',
            },
            'ARBMultitexture': {
                33984: 'GL_TEXTURE0_ARB',
                33985: 'GL_TEXTURE1_ARB',
                33986: 'GL_TEXTURE2_ARB',
                33987: 'GL_TEXTURE3_ARB',
                33988: 'GL_TEXTURE4_ARB',
                33989: 'GL_TEXTURE5_ARB',
                33990: 'GL_TEXTURE6_ARB',
                33991: 'GL_TEXTURE7_ARB',
                33992: 'GL_TEXTURE8_ARB',
                33993: 'GL_TEXTURE9_ARB',
                33994: 'GL_TEXTURE10_ARB',
                33995: 'GL_TEXTURE11_ARB',
                33996: 'GL_TEXTURE12_ARB',
                33997: 'GL_TEXTURE13_ARB',
                33998: 'GL_TEXTURE14_ARB',
                33999: 'GL_TEXTURE15_ARB',
                34000: 'GL_TEXTURE16_ARB',
                34001: 'GL_TEXTURE17_ARB',
                34002: 'GL_TEXTURE18_ARB',
                34003: 'GL_TEXTURE19_ARB',
                34004: 'GL_TEXTURE20_ARB',
                34005: 'GL_TEXTURE21_ARB',
                34006: 'GL_TEXTURE22_ARB',
                34007: 'GL_TEXTURE23_ARB',
                34008: 'GL_TEXTURE24_ARB',
                34009: 'GL_TEXTURE25_ARB',
                34010: 'GL_TEXTURE26_ARB',
                34011: 'GL_TEXTURE27_ARB',
                34012: 'GL_TEXTURE28_ARB',
                34013: 'GL_TEXTURE29_ARB',
                34014: 'GL_TEXTURE30_ARB',
                34015: 'GL_TEXTURE31_ARB',
                34016: 'GL_ACTIVE_TEXTURE_ARB',
                34017: 'GL_CLIENT_ACTIVE_TEXTURE_ARB',
                34018: 'GL_MAX_TEXTURE_UNITS_ARB',
            },
            'ARBOcclusionQuery': {
                34916: 'GL_QUERY_COUNTER_BITS_ARB',
                34917: 'GL_CURRENT_QUERY_ARB',
                34918: 'GL_QUERY_RESULT_ARB',
                34919: 'GL_QUERY_RESULT_AVAILABLE_ARB',
                35092: 'GL_SAMPLES_PASSED_ARB',
            },
            'ARBVertexBufferObject': {
                34660: 'GL_BUFFER_SIZE_ARB',
                34661: 'GL_BUFFER_USAGE_ARB',
                34962: 'GL_ARRAY_BUFFER_ARB',
                34963: 'GL_ELEMENT_ARRAY_BUFFER_ARB',
                34964: 'GL_ARRAY_BUFFER_BINDING_ARB',
                34965: 'GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB',
                34966: 'GL_VERTEX_ARRAY_BUFFER_BINDING_ARB',
                34967: 'GL_NORMAL_ARRAY_BUFFER_BINDING_ARB',
                34968: 'GL_COLOR_ARRAY_BUFFER_BINDING_ARB',
                34969: 'GL_INDEX_ARRAY_BUFFER_BINDING_ARB',
                34970: 'GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB',
                34971: 'GL_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB',
                34972: 'GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB',
                34973: 'GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB',
                34974: 'GL_WEIGHT_ARRAY_BUFFER_BINDING_ARB',
                34975: 'GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING_ARB',
                35000: 'GL_READ_ONLY_ARB',
                35001: 'GL_WRITE_ONLY_ARB',
                35002: 'GL_READ_WRITE_ARB',
                35003: 'GL_BUFFER_ACCESS_ARB',
                35004: 'GL_BUFFER_MAPPED_ARB',
                35005: 'GL_BUFFER_MAP_POINTER_ARB',
                35040: 'GL_STREAM_DRAW_ARB',
                35041: 'GL_STREAM_READ_ARB',
                35042: 'GL_STREAM_COPY_ARB',
                35044: 'GL_STATIC_DRAW_ARB',
                35045: 'GL_STATIC_READ_ARB',
                35046: 'GL_STATIC_COPY_ARB',
                35048: 'GL_DYNAMIC_DRAW_ARB',
                35049: 'GL_DYNAMIC_READ_ARB',
                35050: 'GL_DYNAMIC_COPY_ARB',
            },
        }
    ),
    (
        {
            'ARBShaderObjects': [
                'glGetObjectParameterARB',
                'glGetObjectParameterfARB',
                'glGetObjectParameteriARB',
                'glCreateShaderObjectARB',
            ],
        },
        {
            'ARBShaderObjects': {
                35662: 'GL_OBJECT_TYPE_ARB',
                35663: 'GL_OBJECT_SUBTYPE_ARB',
                35712: 'GL_OBJECT_DELETE_STATUS_ARB',
                35713: 'GL_OBJECT_COMPILE_STATUS_ARB',
                35714: 'GL_OBJECT_LINK_STATUS_ARB',
                35715: 'GL_OBJECT_VALIDATE_STATUS_ARB',
                35716: 'GL_OBJECT_INFO_LOG_LENGTH_ARB',
                35717: 'GL_OBJECT_ATTACHED_OBJECTS_ARB',
                35718: 'GL_OBJECT_ACTIVE_UNIFORMS_ARB',
                35719: 'GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB',
                35720: 'GL_OBJECT_SHADER_SOURCE_LENGTH_ARB',
            },
            'ARBFragmentShader': {
                35632: 'GL_FRAGMENT_SHADER_ARB',
            },
            'ARBVertexShader': {
                35633: 'GL_VERTEX_SHADER_ARB',
            },
        }
    ),
]

_CALL_REGEX = re.compile(r'(' + '|'.join(_PACKAGES) + r')\.([\w]+)\(.+\)')
_CONSTANT_REGEX = re.compile(r'(?<![-.\w])\d+(?![.\w])')


def annotate_constants(code):
    def process_call(match):
        full_call = match.group(0)
        package = match.group(1)
        method = match.group(2)

        def expand_constant(match):
            full_match = match.group(0)
            constant = int(full_match)
            for group in _CONSTANTS:
                if package in group[0] and method in group[0][package]:
                    for constpkg, const in group[1].items():
                        if constant in const:
                            return '%s.%s' % (constpkg, const[constant])
            return full_match
        return _CONSTANT_REGEX.sub(expand_constant, full_call)
    return _CALL_REGEX.sub(process_call, code)


def update_imports(code, imp):
    add_after = 'org.lwjgl.opengl.GL11'
    if 'import %s;\n' % imp not in code:
        code = code.replace('import %s;\n' % add_after,
                            'import %s;\nimport %s;\n' % (add_after, imp))
    return code


def annotate_file(filename):
    tmp_file = filename + '.tmp'
    with open(filename, 'r') as fh:
        code = fh.read()
    if 'import org.lwjgl.opengl.' in code:
        code = annotate_constants(code)
        for pkg in _PACKAGES:
            if pkg + '.' in code:
                code = update_imports(code, 'org.lwjgl.opengl.' + pkg)
        with open(tmp_file, 'w') as fh:
            fh.write(code)
        shutil.move(tmp_file, filename)


def annotate_dir(srcdir):
    for path, _, filelist in os.walk(srcdir, followlinks=True):
        for cur_file in fnmatch.filter(filelist, '*.java'):
            src_file = os.path.normpath(os.path.join(path, cur_file))
            annotate_file(src_file)


def main():
    usage = 'usage: %prog [options] src_dir'
    version = '%prog 6.0'
    parser = OptionParser(version=version, usage=usage)
    options, args = parser.parse_args()
    if len(args) != 1:
        print >> sys.stderr, 'src_dir required'
        sys.exit(1)
    annotate_dir(args[0])


if __name__ == '__main__':
    main()
