/*
 * Decompiled with CFR 0.152.
 */
package mcp.mcinjector;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import mcp.StringUtil;
import mcp.mcinjector.LogFormatter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;

public class MCInjectorImpl {
    private static final Logger log = Logger.getLogger("MCInjector");
    public final Properties mappings = new Properties();
    public final Properties outMappings = new Properties(){
        private static final long serialVersionUID = 4112578634029874840L;

        @Override
        public synchronized Enumeration keys() {
            Enumeration<Object> keysEnum = super.keys();
            Vector<Object> keyList = new Vector<Object>();
            while (keysEnum.hasMoreElements()) {
                keyList.add(keysEnum.nextElement());
            }
            Collections.sort(keyList);
            return keyList.elements();
        }
    };
    private int initIndex = 0;

    public static void process(String inFile, String outFile, String mapFile, String logFile, String outMapFile, int index) throws IOException {
        log.setUseParentHandlers(false);
        log.setLevel(Level.ALL);
        if (logFile != null) {
            FileHandler filehandler = new FileHandler(logFile);
            filehandler.setFormatter(new LogFormatter());
            log.addHandler(filehandler);
        }
        MCInjectorImpl mci = new MCInjectorImpl(index);
        mci.loadMap(mapFile);
        mci.processJar(inFile, outFile);
        if (outMapFile != null) {
            mci.saveMap(outMapFile);
        }
        System.out.println("Processed " + inFile);
    }

    private MCInjectorImpl(int index) {
        this.initIndex = index;
    }

    public void loadMap(String mapFile) throws IOException {
        FileReader mapReader = null;
        try {
            mapReader = new FileReader(mapFile);
            this.mappings.load(mapReader);
        }
        catch (IOException e) {
            throw new IOException("Could not open map file: " + e.getMessage());
        }
        finally {
            if (mapReader != null) {
                try {
                    ((Reader)mapReader).close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void saveMap(String mapFile) throws IOException {
        FileWriter mapWriter = null;
        try {
            mapWriter = new FileWriter(mapFile);
            if (this.initIndex > 0) {
                this.outMappings.store(mapWriter, "max index=" + this.initIndex);
            } else {
                this.outMappings.store(mapWriter, null);
            }
        }
        catch (IOException e) {
            throw new IOException("Could not write map file: " + e.getMessage());
        }
        finally {
            if (mapWriter != null) {
                try {
                    ((Writer)mapWriter).close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processJar(String inFile, String outFile) throws IOException {
        ZipInputStream inJar = null;
        ZipOutputStream outJar = null;
        try {
            ZipEntry entry;
            try {
                inJar = new ZipInputStream(new BufferedInputStream(new FileInputStream(inFile)));
            }
            catch (FileNotFoundException e) {
                throw new FileNotFoundException("Could not open input file: " + e.getMessage());
            }
            try {
                outJar = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outFile)));
            }
            catch (FileNotFoundException e) {
                throw new FileNotFoundException("Could not open output file: " + e.getMessage());
            }
            while ((entry = inJar.getNextEntry()) != null) {
                int len;
                if (entry.isDirectory()) {
                    outJar.putNextEntry(entry);
                    continue;
                }
                byte[] data = new byte[4096];
                ByteArrayOutputStream entryBuffer = new ByteArrayOutputStream();
                do {
                    if ((len = inJar.read(data)) <= 0) continue;
                    entryBuffer.write(data, 0, len);
                } while (len != -1);
                byte[] entryData = entryBuffer.toByteArray();
                String entryName = entry.getName();
                if (entryName.endsWith(".class") && !entryName.startsWith(".")) {
                    log.log(Level.INFO, "Processing " + entryName);
                    entryData = this.processClass(entryData);
                    log.log(Level.INFO, "Processed " + entryBuffer.size() + " -> " + entryData.length);
                } else {
                    log.log(Level.INFO, "Copying " + entryName);
                }
                ZipEntry newEntry = new ZipEntry(entryName);
                outJar.putNextEntry(newEntry);
                outJar.write(entryData);
            }
        }
        finally {
            if (outJar != null) {
                try {
                    outJar.close();
                }
                catch (IOException e) {}
            }
            if (inJar != null) {
                try {
                    inJar.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public byte[] processClass(byte[] input) {
        ClassReader reader = new ClassReader(input);
        ClassNode classNode = new ClassNode();
        reader.accept(classNode, 0);
        log.log(Level.FINE, "Class: " + classNode.name + " Extends: " + classNode.superName);
        for (MethodNode methodNode : classNode.methods) {
            log.log(Level.FINER, "Name: " + methodNode.name + " Desc: " + methodNode.desc);
            String clsSig = classNode.name + "." + methodNode.name + methodNode.desc;
            String excList = null;
            String parList = null;
            String curMap = this.mappings.getProperty(clsSig);
            if (curMap != null) {
                List<String> splitMap = StringUtil.splitString(curMap, "|", -1);
                excList = splitMap.get(0);
                if (splitMap.size() > 1) {
                    parList = splitMap.get(1);
                }
            }
            try {
                String exceptions = this.processExceptions(classNode, methodNode, excList);
                String parameters = this.processLVT(classNode, methodNode, parList);
                if (exceptions.length() <= 0 && parameters == null) continue;
                if (parameters == null) {
                    parameters = "";
                }
                this.outMappings.setProperty(clsSig, exceptions + "|" + parameters);
            }
            catch (RuntimeException e) {
                throw new RuntimeException(clsSig, e);
            }
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept(writer);
        return writer.toByteArray();
    }

    public String processExceptions(ClassNode classNode, MethodNode methodNode, String excList) {
        if (methodNode.exceptions == null) {
            methodNode.exceptions = new ArrayList();
        }
        List<Object> exceptions = null;
        if (excList != null) {
            exceptions = new ArrayList();
            if (!excList.equals("")) {
                exceptions = StringUtil.splitString(excList, ",");
            }
        } else if (this.initIndex > 0) {
            // empty if block
        }
        if (exceptions != null) {
            log.log(Level.FINE, "Adding Exceptions: " + excList);
            methodNode.exceptions = exceptions;
        }
        return StringUtil.joinString(methodNode.exceptions, ",");
    }

    public String processLVT(ClassNode classNode, MethodNode methodNode, String parList) {
        int y;
        if (classNode.name.startsWith("paulscode/") || classNode.name.startsWith("com/jcraft/")) {
            return null;
        }
        if (methodNode.name.equals("<clinit>")) {
            return null;
        }
        if ((methodNode.access & 0x400) != 0 || (methodNode.access & 0x100) != 0) {
            return "";
        }
        if (methodNode.localVariables == null) {
            methodNode.localVariables = new ArrayList();
        }
        boolean doLVT = false;
        int idxOffset = 0;
        ArrayList<String> argNames = new ArrayList<String>();
        ArrayList<Type> argTypes = new ArrayList<Type>();
        if ((methodNode.access & 8) == 0) {
            idxOffset = 1;
            argNames.add("this");
            argTypes.add(Type.getType("L" + classNode.name + ";"));
        }
        argTypes.addAll(Arrays.asList(Type.getArgumentTypes(methodNode.desc)));
        if (parList != null) {
            doLVT = true;
            if (!parList.equals("")) {
                argNames.addAll(StringUtil.splitString(parList, ","));
            }
        } else if (this.initIndex > 0) {
            if (methodNode.name.matches("func_\\d+_.+")) {
                int x;
                String funcId = methodNode.name.substring(5, methodNode.name.indexOf(95, 5));
                int y2 = x = idxOffset;
                while (x < argTypes.size()) {
                    argNames.add(String.format("p_%s_%d_", funcId, y2));
                    String desc = ((Type)argTypes.get(x)).getDescriptor();
                    if (desc.equals("J") || desc.equals("D")) {
                        ++y2;
                    }
                    ++x;
                    ++y2;
                }
            } else if (methodNode.name.equals("<init>")) {
                if (argTypes.size() > idxOffset) {
                    int x;
                    y = x = idxOffset;
                    while (x < argTypes.size()) {
                        argNames.add(String.format("p_i%d_%d_", this.initIndex, y));
                        String desc = ((Type)argTypes.get(x)).getDescriptor();
                        if (desc.equals("J") || desc.equals("D")) {
                            ++y;
                        }
                        ++x;
                        ++y;
                    }
                    ++this.initIndex;
                }
            } else {
                int x;
                y = x = idxOffset;
                while (x < argTypes.size()) {
                    argNames.add(String.format("p_%s_%d_", methodNode.name, y));
                    String desc = ((Type)argTypes.get(x)).getDescriptor();
                    if (desc.equals("J") || desc.equals("D")) {
                        ++y;
                    }
                    ++x;
                    ++y;
                }
            }
            doLVT = true;
        } else if (this.initIndex < 0) {
            int x;
            y = x = idxOffset;
            while (x < argTypes.size()) {
                argNames.add("par" + y);
                String desc = ((Type)argTypes.get(x)).getDescriptor();
                if (desc.equals("J") || desc.equals("D")) {
                    ++y;
                }
                ++x;
                ++y;
            }
            doLVT = true;
        }
        if (doLVT) {
            int x;
            if (argNames.size() != argTypes.size()) {
                throw new RuntimeException("Incorrect argument count");
            }
            AbstractInsnNode tmp = methodNode.instructions.getFirst();
            if (tmp == null) {
                methodNode.instructions.add(new LabelNode());
            } else if (tmp.getType() != 8) {
                methodNode.instructions.insertBefore(tmp, new LabelNode());
            }
            LabelNode start = (LabelNode)methodNode.instructions.getFirst();
            tmp = methodNode.instructions.getLast();
            if (tmp == null) {
                methodNode.instructions.add(new LabelNode());
            } else if (tmp.getType() != 8) {
                methodNode.instructions.insert(tmp, new LabelNode());
            }
            LabelNode end = (LabelNode)methodNode.instructions.getLast();
            methodNode.localVariables = new ArrayList();
            int y3 = x = 0;
            while (x < argNames.size()) {
                String arg = (String)argNames.get(x);
                String desc = ((Type)argTypes.get(x)).getDescriptor();
                if (arg.equals("")) {
                    log.log(Level.FINE, "Skipping argument " + x + " (" + y3 + ") -> " + desc);
                } else {
                    log.log(Level.FINE, "Naming argument " + x + " (" + y3 + ") -> " + arg + " " + desc);
                    methodNode.localVariables.add(new LocalVariableNode(arg, desc, null, start, end, y3));
                }
                if (desc.equals("J") || desc.equals("D")) {
                    ++y3;
                }
                ++x;
                ++y3;
            }
        }
        ArrayList<String> variables = new ArrayList<String>();
        HashMap<Integer, String> lvIndex = new HashMap<Integer, String>();
        if (methodNode.localVariables != null) {
            for (LocalVariableNode lv : methodNode.localVariables) {
                lvIndex.put(lv.index, lv.name);
            }
            if (argTypes.size() > idxOffset) {
                int x;
                int y4 = x = idxOffset;
                while (x < argTypes.size()) {
                    String name = (String)lvIndex.get(y4);
                    if (name == null) {
                        name = "";
                    }
                    variables.add(name);
                    String desc = ((Type)argTypes.get(x)).getDescriptor();
                    if (desc.equals("J") || desc.equals("D")) {
                        ++y4;
                    }
                    ++x;
                    ++y4;
                }
            }
        }
        return StringUtil.joinString(variables, ",");
    }
}

