/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.specialsource;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.HashMap;
import java.util.Map;

public class AccessChange {
    private int clear;
    private int set;
    private int vis;
    private static final Map<String, Integer> accessCodes = new HashMap<String, Integer>();
    private static final BiMap<Integer, Integer> visibilityOrder;
    private static final int MASK_ALL_VISIBILITY = 7;

    public AccessChange(String s) {
        String[] parts = s.split("(?=[+-])");
        if (parts.length < 1) {
            throw new IllegalArgumentException("Invalid access string: " + s);
        }
        String visibilityString = parts[0];
        if (!accessCodes.containsKey(visibilityString)) {
            throw new IllegalArgumentException("Invalid access visibility: " + visibilityString);
        }
        this.vis = accessCodes.get(visibilityString);
        if (this.vis > 4) {
            throw new IllegalArgumentException("Invalid access visibility: " + visibilityString);
        }
        block4: for (int i = 1; i < parts.length; ++i) {
            if (parts[i].length() < 2) {
                throw new IllegalArgumentException("Invalid modifier length " + parts[i] + " in access string: " + s);
            }
            char actionChar = parts[i].charAt(0);
            String modifierString = parts[i].substring(1);
            if (!accessCodes.containsKey(modifierString)) {
                throw new IllegalArgumentException("Invalid modifier string " + modifierString + " in access string: " + s);
            }
            int modifier = accessCodes.get(modifierString);
            switch (actionChar) {
                case '+': {
                    this.set |= modifier;
                    continue block4;
                }
                case '-': {
                    this.clear |= modifier;
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException("Invalid action " + actionChar + " in access string: " + s);
                }
            }
        }
    }

    public int apply(int access) {
        access = AccessChange.setVisibility(access, AccessChange.upgradeVisibility(access & 7, this.vis));
        access &= ~this.clear;
        return access |= this.set;
    }

    public void merge(AccessChange rhs) {
        this.clear |= rhs.clear;
        if ((rhs.set & 7) != 0) {
            this.set &= 0xFFFFFFF8;
        }
        this.set |= rhs.set;
    }

    private static int upgradeVisibility(int existing, int desired) {
        if (!visibilityOrder.containsKey(existing) || !visibilityOrder.containsKey(desired)) {
            throw new IllegalArgumentException("Unrecognized visibility: " + existing + " or " + desired);
        }
        int existingOrder = (Integer)visibilityOrder.get(existing);
        int desiredOrder = (Integer)visibilityOrder.get(desired);
        int newOrder = Math.max(existingOrder, desiredOrder);
        return (Integer)visibilityOrder.inverse().get(newOrder);
    }

    private static int setVisibility(int access, int visibility) {
        access &= 0xFFFFFFF8;
        return access |= visibility;
    }

    public String toString() {
        return "AccessChange(clear=" + this.clear + ", set=" + this.set + ", vis=" + this.vis + ")";
    }

    static {
        accessCodes.put("public", 1);
        accessCodes.put("private", 2);
        accessCodes.put("*", 2);
        accessCodes.put("protected", 4);
        accessCodes.put("default", 0);
        accessCodes.put("", 0);
        accessCodes.put("package-private", 0);
        accessCodes.put("static", 8);
        accessCodes.put("final", 16);
        accessCodes.put("f", 16);
        accessCodes.put("super", 32);
        accessCodes.put("synchronized", 32);
        accessCodes.put("volatile", 64);
        accessCodes.put("bridge", 64);
        accessCodes.put("varargs", 128);
        accessCodes.put("transient", 128);
        accessCodes.put("native", 256);
        accessCodes.put("interface", 512);
        accessCodes.put("abstract", 1024);
        accessCodes.put("strict", 2048);
        accessCodes.put("synthetic", 4096);
        accessCodes.put("annotation", 8192);
        accessCodes.put("enum", 16384);
        accessCodes.put("deprecated", 131072);
        visibilityOrder = HashBiMap.create();
        visibilityOrder.put(2, 100);
        visibilityOrder.put(0, 200);
        visibilityOrder.put(4, 300);
        visibilityOrder.put(1, 400);
    }
}

