/*
 * Decompiled with CFR 0.152.
 */
package de.oceanlabs.mcp.mcinjector;

import de.oceanlabs.mcp.mcinjector.MCInjectorImpl;
import de.oceanlabs.mcp.mcinjector.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class GenerateMapClassAdapter
extends ClassVisitor {
    private static final Logger log = Logger.getLogger("MCInjector");
    private MCInjectorImpl mci;
    String className;

    public GenerateMapClassAdapter(ClassVisitor cv, MCInjectorImpl mci) {
        super(262144, cv);
        this.mci = mci;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        log.log(Level.FINE, "Class: " + name + " Extends: " + superName);
        this.className = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (name.equals("<clinit>")) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        log.log(Level.FINE, "  Name: " + name + " Desc: " + desc + " Sig: " + signature);
        String clsSig = this.className + "." + name + desc;
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Type> types = new ArrayList<Type>();
        int idx = 0;
        if ((access & 8) == 0) {
            idx = 1;
            names.add("this");
            types.add(Type.getType("L" + this.className + ";"));
        }
        types.addAll(Arrays.asList(Type.getArgumentTypes(desc)));
        if (types.size() == 0) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        log.fine("    Generating map:");
        if (this.mci.initIndex < 0) {
            this.generateGenerics(idx, names, types);
        } else {
            this.generateUnique(idx, clsSig, name, names, types);
        }
        if (names.size() > idx) {
            this.mci.setParams(clsSig, StringUtil.joinString(names.subList(idx, names.size()), ","));
        } else {
            this.mci.setParams(clsSig, "");
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    private void generateGenerics(int idx, List<String> names, List<Type> types) {
        int x;
        int y = x = idx;
        while (x < types.size()) {
            names.add("par" + y);
            log.fine("      Naming argument " + x + " (" + y + ") -> par" + y + " " + types.get(x).getDescriptor());
            String desc = types.get(x).getDescriptor();
            if (desc.equals("J") || desc.equals("D")) {
                ++y;
            }
            ++x;
            ++y;
        }
    }

    private void generateUnique(int idx, String clsSig, String methodName, List<String> names, List<Type> types) {
        block9: {
            int x;
            block10: {
                int x2;
                String tmp;
                block8: {
                    int x3;
                    if (!methodName.matches("func_\\d+_.+")) break block8;
                    String funcId = methodName.substring(5, methodName.indexOf(95, 5));
                    int y = x3 = idx;
                    while (x3 < types.size()) {
                        String desc = types.get(x3).getDescriptor();
                        String name = String.format("p_%s_%d_", funcId, y);
                        names.add(name);
                        log.fine("      Naming argument " + x3 + " (" + y + ") -> " + name + " " + desc);
                        if (desc.equals("J") || desc.equals("D")) {
                            ++y;
                        }
                        ++x3;
                        ++y;
                    }
                    break block9;
                }
                if (!methodName.equals("<init>")) break block10;
                if (types.size() <= idx) break block9;
                int conID = -1;
                List<String> old = this.mci.getParams(clsSig);
                String string = tmp = old.size() > 0 ? old.get(0) : "";
                if (tmp.matches("p_i\\d+_\\d+_")) {
                    conID = Integer.parseInt(tmp.substring(3, tmp.indexOf(95, 3)));
                    log.fine("      Constructor ID loaded " + conID);
                } else {
                    conID = this.mci.initIndex++;
                    log.fine("      Constructor ID assigned " + conID);
                }
                int y = x2 = idx;
                while (x2 < types.size()) {
                    String desc = types.get(x2).getDescriptor();
                    String name = String.format("p_i%d_%d_", conID, y);
                    names.add(name);
                    log.fine("      Naming argument " + x2 + " (" + y + ") -> " + name + " " + desc);
                    if (desc.equals("J") || desc.equals("D")) {
                        ++y;
                    }
                    ++x2;
                    ++y;
                }
                break block9;
            }
            int y = x = idx;
            while (x < types.size()) {
                String desc = types.get(x).getDescriptor();
                String name = String.format("p_%s_%d_", methodName, y);
                names.add(name);
                log.fine("      Naming argument " + x + " (" + y + ") -> " + name + " " + desc);
                if (desc.equals("J") || desc.equals("D")) {
                    ++y;
                }
                ++x;
                ++y;
            }
        }
    }
}

