/*
 * Decompiled with CFR 0.152.
 */
package de.oceanlabs.mcp.mcinjector;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class InheratanceMap {
    private Map<String, Class> classes = new HashMap<String, Class>();

    public void processClass(byte[] data) {
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(data);
        reader.accept(node, 7);
        Class cls = this.getClass(node.name);
        cls.parent = this.getClass(node.superName);
        cls.wasRead = true;
        for (FieldNode fieldNode : node.fields) {
            cls.fields.put(fieldNode.name + fieldNode.desc, new Node(cls, fieldNode.name, fieldNode.desc, fieldNode.access));
        }
        for (MethodNode methodNode : node.methods) {
            cls.methods.put(methodNode.name + methodNode.desc, new Node(cls, methodNode.name, methodNode.desc, methodNode.access));
        }
    }

    public Class getClass(String name) {
        Class cls = this.classes.get(name);
        if (cls == null) {
            cls = new Class(name);
            this.classes.put(name, cls);
        }
        return cls;
    }

    public static enum Access {
        PRIVATE,
        DEFAULT,
        PROTECTED,
        PUBLIC;


        public static Access getFromBytecode(int acc) {
            if ((acc & 2) == 2) {
                return PRIVATE;
            }
            if ((acc & 4) == 4) {
                return PROTECTED;
            }
            if ((acc & 1) == 1) {
                return PUBLIC;
            }
            return DEFAULT;
        }

        public int setAccess(int acc) {
            acc &= 0xFFFFFFF8;
            acc |= this == PRIVATE ? 2 : 0;
            acc |= this == PROTECTED ? 4 : 0;
            return acc |= this == PUBLIC ? 1 : 0;
        }
    }

    public static class Node {
        public final Class owner;
        public final String name;
        public final String desc;
        public final int access;
        private final int hash;

        Node(Class owner, String name, String desc, int access) {
            this.owner = owner;
            this.name = name;
            this.desc = desc;
            this.access = access;
            this.hash = (name + desc).hashCode();
        }

        public int hashCode() {
            return this.hash;
        }
    }

    public static class Class {
        private boolean wasRead = false;
        public Class parent;
        public final String name;
        private Map<String, Node> fields = new HashMap<String, Node>();
        private Map<String, Node> methods = new HashMap<String, Node>();

        public Class(String name) {
            this.name = name;
        }

        public Node traverseMethod(String name, String desc) {
            String key = name + desc;
            Class cls = this;
            Node ret = cls.methods.get(key);
            if (name.startsWith("<")) {
                return ret;
            }
            while (cls != null && cls.wasRead) {
                if (cls.methods.containsKey(key)) {
                    ret = cls.methods.get(key);
                }
                cls = cls.parent;
            }
            return ret;
        }
    }
}

