/*
 * Decompiled with CFR 0.152.
 */
package de.oceanlabs.mcp.mcinjector;

import de.oceanlabs.mcp.mcinjector.JsonStruct;
import de.oceanlabs.mcp.mcinjector.MCInjectorImpl;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.objectweb.asm.ClassVisitor;

public class JsonAttributeClassAdaptor
extends ClassVisitor {
    private static final Logger log = Logger.getLogger("MCInjector");
    private MCInjectorImpl mci;
    private String className;
    private JsonStruct json;
    private boolean visitedOuter = false;
    private Set<String> visitedInners = new HashSet<String>();

    public JsonAttributeClassAdaptor(ClassVisitor cv, MCInjectorImpl mci) {
        super(262144, cv);
        this.mci = mci;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        this.json = this.mci.json.get(this.className);
        this.visitedOuter = false;
        this.visitedInners.clear();
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.visitedInners.add(name);
        super.visitInnerClass(name, outerName, innerName, access);
    }

    @Override
    public void visitOuterClass(String owner, String name, String desc) {
        this.visitedOuter = true;
        super.visitOuterClass(owner, name, desc);
    }

    @Override
    public void visitEnd() {
        if (this.json == null) {
            super.visitEnd();
            return;
        }
        JsonStruct.EnclosingMethod enc = this.json.enclosingMethod;
        if (enc != null && !this.visitedOuter && enc.name != null && enc.desc != null) {
            log.fine("Adding Outer Class: " + enc.owner + " " + enc.name + " " + enc.desc);
            super.visitOuterClass(enc.owner, enc.name, enc.desc);
        }
        if (this.json.innerClasses != null) {
            for (JsonStruct.InnerClass inner : this.json.innerClasses) {
                if (this.visitedInners.contains(inner.inner_class)) continue;
                log.fine("Adding Inner Class: " + inner.inner_class + " " + inner.getAccess() + " " + inner.outer_class + " " + inner.inner_name);
                super.visitInnerClass(inner.inner_class, inner.outer_class, inner.inner_name, inner.getAccess());
            }
        }
    }
}

