/*
 * Decompiled with CFR 0.152.
 */
package COM.rl.obf.classfile;

import COM.rl.obf.classfile.AnnotationInfo;
import COM.rl.obf.classfile.ClassFile;
import COM.rl.obf.classfile.ClassFileException;
import COM.rl.obf.classfile.ConstantPool;
import COM.rl.obf.classfile.NameMapper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MemberValueInfo {
    private int u1tag;
    private int u2constValueIndex;
    private int u2typeNameIndex;
    private int u2constNameIndex;
    private int u2classInfoIndex;
    private AnnotationInfo annotationValue;
    private List<MemberValueInfo> values;

    public static MemberValueInfo create(DataInput din) throws IOException, ClassFileException {
        MemberValueInfo mvi = new MemberValueInfo();
        mvi.read(din);
        return mvi;
    }

    private MemberValueInfo() {
    }

    protected int getTag() {
        return this.u1tag;
    }

    protected void markUtf8Refs(ConstantPool pool) throws ClassFileException {
        switch (this.u1tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: {
                break;
            }
            case 115: {
                pool.incRefCount(this.u2constValueIndex);
                break;
            }
            case 101: {
                pool.incRefCount(this.u2typeNameIndex);
                pool.incRefCount(this.u2constNameIndex);
                break;
            }
            case 99: {
                pool.incRefCount(this.u2classInfoIndex);
                break;
            }
            case 64: {
                this.annotationValue.markUtf8Refs(pool);
                break;
            }
            case 91: {
                for (MemberValueInfo mv : this.values) {
                    mv.markUtf8Refs(pool);
                }
                break;
            }
            default: {
                throw new ClassFileException("Illegal tag value in annotation attribute member_value structure: " + this.u1tag);
            }
        }
    }

    private void read(DataInput din) throws IOException, ClassFileException {
        this.u1tag = din.readUnsignedByte();
        switch (this.u1tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                this.u2constValueIndex = din.readUnsignedShort();
                break;
            }
            case 101: {
                this.u2typeNameIndex = din.readUnsignedShort();
                this.u2constNameIndex = din.readUnsignedShort();
                break;
            }
            case 99: {
                this.u2classInfoIndex = din.readUnsignedShort();
                break;
            }
            case 64: {
                this.annotationValue = AnnotationInfo.create(din);
                break;
            }
            case 91: {
                int u2numValues = din.readUnsignedShort();
                this.values = new ArrayList<MemberValueInfo>(u2numValues);
                for (int i = 0; i < u2numValues; ++i) {
                    this.values.add(MemberValueInfo.create(din));
                }
                break;
            }
            default: {
                throw new ClassFileException("Illegal tag value in annotation attribute member_value structure: " + this.u1tag);
            }
        }
    }

    public void write(DataOutput dout) throws IOException, ClassFileException {
        dout.writeByte(this.u1tag);
        switch (this.u1tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                dout.writeShort(this.u2constValueIndex);
                break;
            }
            case 101: {
                dout.writeShort(this.u2typeNameIndex);
                dout.writeShort(this.u2constNameIndex);
                break;
            }
            case 99: {
                dout.writeShort(this.u2classInfoIndex);
                break;
            }
            case 64: {
                this.annotationValue.write(dout);
                break;
            }
            case 91: {
                dout.writeShort(this.values.size());
                for (MemberValueInfo mv : this.values) {
                    mv.write(dout);
                }
                break;
            }
            default: {
                throw new ClassFileException("Illegal tag value in annotation attribute member_value structure: " + this.u1tag);
            }
        }
    }

    protected void remap(ClassFile cf, NameMapper nm) throws ClassFileException {
        switch (this.u1tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                break;
            }
            case 101: {
                break;
            }
            case 99: {
                String oldDesc = cf.getUtf8(this.u2classInfoIndex);
                String newDesc = nm.mapDescriptor(oldDesc);
                this.u2classInfoIndex = cf.remapUtf8To(newDesc, this.u2classInfoIndex);
                break;
            }
            case 64: {
                this.annotationValue.remap(cf, nm);
                break;
            }
            case 91: {
                for (MemberValueInfo mv : this.values) {
                    mv.remap(cf, nm);
                }
                break;
            }
            default: {
                throw new ClassFileException("Illegal tag value in annotation attribute member_value structure: " + this.u1tag);
            }
        }
    }
}

