/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.attr;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.util.DataInputFullStream;

public class StructInnerClassesAttribute
extends StructGeneralAttribute {
    private List<InnerClassInfo> entries;

    @Override
    public void initContent(ConstantPool pool) throws IOException {
        DataInputFullStream data = this.stream();
        int len = data.readUnsignedShort();
        if (len > 0) {
            this.entries = new ArrayList<InnerClassInfo>();
            for (int i = 0; i < len; ++i) {
                this.entries.add(new InnerClassInfo(data, pool));
            }
        } else {
            this.entries = Collections.emptyList();
        }
    }

    public List<InnerClassInfo> getEntries() {
        return this.entries;
    }

    public static class InnerClassInfo {
        public String inner_class;
        public String outer_class;
        public String inner_name;
        public int access;

        private InnerClassInfo(DataInputStream data, ConstantPool pool) throws IOException {
            this.inner_class = this.readString(pool, data.readUnsignedShort());
            this.outer_class = this.readString(pool, data.readUnsignedShort());
            this.inner_name = this.readString(pool, data.readUnsignedShort());
            this.access = data.readUnsignedShort();
        }

        private String readString(ConstantPool pool, int index) {
            return index == 0 ? null : pool.getPrimitiveConstant(index).getString();
        }
    }
}

