/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.mmv.gui;

import bspkrs.mmv.McpMappingLoader;
import bspkrs.mmv.VersionFetcher;
import bspkrs.mmv.gui.TableColumnAdjuster;
import bspkrs.mmv.version.AppVersionChecker;
import immibis.bon.IProgressListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class MappingGui
extends JFrame {
    public static final String VERSION_NUMBER = "1.0.0";
    private static final long serialVersionUID = 1L;
    private final Preferences prefs = Preferences.userNodeForPackage(MappingGui.class);
    private JFrame frmMcpMappingViewer;
    private JButton btnRefreshTables;
    private JComboBox<String> cmbMappingVersion;
    private JCheckBox chkForceRefresh;
    private JPanel pnlProgress;
    private JProgressBar progressBar;
    private JPanel pnlFilter;
    private JComboBox<String> cmbFilter;
    private JButton btnSearch;
    private JButton btnGetBotCommands;
    private JButton btnSave;
    private JCheckBox chkClearOnCopy;
    private static final String PREFS_KEY_FILTER = "filter";
    private static final String PREFS_KEY_CLASS_SORT = "classSort";
    private static final String PREFS_KEY_METHOD_SORT = "methodSort";
    private static final String PREFS_KEY_PARAM_SORT = "paramSort";
    private static final String PREFS_KEY_FIELD_SORT = "fieldSort";
    private final List<RowSorter.SortKey> classSort = new ArrayList<RowSorter.SortKey>();
    private final List<RowSorter.SortKey> methodSort = new ArrayList<RowSorter.SortKey>();
    private final List<RowSorter.SortKey> paramSort = new ArrayList<RowSorter.SortKey>();
    private final List<RowSorter.SortKey> fieldSort = new ArrayList<RowSorter.SortKey>();
    private JTable tblClasses;
    private JTable tblMethods;
    private JTable tblFields;
    private JTable tblParams;
    private Thread curTask = null;
    private final Map<String, McpMappingLoader> mcpInstances = new HashMap<String, McpMappingLoader>();
    private final VersionFetcher versionFetcher = new VersionFetcher();
    private McpMappingLoader currentLoader;
    private AppVersionChecker versionChecker;
    private final String versionURL = "http://bspk.rs/Minecraft/MMV/MMV.version";
    private final String mcfTopic = "http://www.minecraftforum.net/topic/2115030-";
    public static DefaultTableModel classesDefaultModel = new DefaultTableModel(new Object[][]{new Object[0]}, new String[]{"Pkg name", "SRG name", "Obf name"}){
        private static final long serialVersionUID = 1L;
        boolean[] columnEditables = new boolean[]{false, false, false};
        Class[] columnTypes = new Class[]{String.class, String.class, String.class};

        public Class getColumnClass(int columnIndex) {
            return this.columnTypes[columnIndex];
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return this.columnEditables[column];
        }
    };
    public static DefaultTableModel methodsDefaultModel = new DefaultTableModel(new Object[][]{new Object[0]}, new String[]{"MCP Name", "SRG Name", "Obf Name", "SRG Descriptor", "Comment"}){
        private static final long serialVersionUID = 1L;
        boolean[] columnEditables = new boolean[]{false, false, false, false, false};
        Class[] columnTypes = new Class[]{String.class, String.class, String.class, String.class, String.class};

        public Class getColumnClass(int columnIndex) {
            return this.columnTypes[columnIndex];
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return this.columnEditables[column];
        }
    };
    public static DefaultTableModel paramsDefaultModel = new DefaultTableModel(new Object[][]{new Object[0]}, new String[]{"MCP Name", "SRG Name", "Type"}){
        private static final long serialVersionUID = 1L;
        boolean[] columnEditables = new boolean[]{false, false, false};
        Class[] columnTypes = new Class[]{String.class, String.class, String.class};

        public Class getColumnClass(int columnIndex) {
            return this.columnTypes[columnIndex];
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return this.columnEditables[column];
        }
    };
    public static DefaultTableModel fieldsDefaultModel = new DefaultTableModel(new Object[][]{new Object[0]}, new String[]{"MCP Name", "SRG Name", "Obf Name", "Comment"}){
        private static final long serialVersionUID = 1L;
        boolean[] columnEditables = new boolean[]{false, false, false, false};
        Class[] columnTypes = new Class[]{String.class, String.class, String.class, String.class};

        public Class getColumnClass(int columnIndex) {
            return this.columnTypes[columnIndex];
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return this.columnEditables[column];
        }
    };
    private JSplitPane splitMethods;
    private JButton btnGetVersions;

    private void savePrefs() {
        SortOrder order;
        int i;
        for (i = 0; i < Math.min(this.cmbFilter.getItemCount(), 20); ++i) {
            this.prefs.put(PREFS_KEY_FILTER + i, this.cmbFilter.getItemAt(i));
        }
        if (this.tblClasses.getRowSorter().getSortKeys().size() > 0) {
            i = this.tblClasses.getRowSorter().getSortKeys().get(0).getColumn() + 1;
            order = this.tblClasses.getRowSorter().getSortKeys().get(0).getSortOrder();
            this.prefs.putInt(PREFS_KEY_CLASS_SORT, order == SortOrder.DESCENDING ? i * -1 : i);
        } else {
            this.prefs.putInt(PREFS_KEY_CLASS_SORT, 1);
        }
        if (this.tblMethods.getRowSorter().getSortKeys().size() > 0) {
            i = this.tblMethods.getRowSorter().getSortKeys().get(0).getColumn() + 1;
            order = this.tblMethods.getRowSorter().getSortKeys().get(0).getSortOrder();
            this.prefs.putInt(PREFS_KEY_METHOD_SORT, order == SortOrder.DESCENDING ? i * -1 : i);
        } else {
            this.prefs.putInt(PREFS_KEY_METHOD_SORT, 1);
        }
        if (this.tblParams.getRowSorter().getSortKeys().size() > 0) {
            i = this.tblParams.getRowSorter().getSortKeys().get(0).getColumn() + 1;
            order = this.tblParams.getRowSorter().getSortKeys().get(0).getSortOrder();
            this.prefs.putInt(PREFS_KEY_PARAM_SORT, order == SortOrder.DESCENDING ? i * -1 : i);
        } else {
            this.prefs.putInt(PREFS_KEY_PARAM_SORT, 1);
        }
        if (this.tblFields.getRowSorter().getSortKeys().size() > 0) {
            i = this.tblFields.getRowSorter().getSortKeys().get(0).getColumn() + 1;
            order = this.tblFields.getRowSorter().getSortKeys().get(0).getSortOrder();
            this.prefs.putInt(PREFS_KEY_FIELD_SORT, order == SortOrder.DESCENDING ? i * -1 : i);
        } else {
            this.prefs.putInt(PREFS_KEY_FIELD_SORT, 1);
        }
    }

    private void loadPrefs(boolean sortOnly) {
        if (!sortOnly) {
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.cmbFilter.getModel();
            for (int i = 0; i < 20; ++i) {
                String item = this.prefs.get(PREFS_KEY_FILTER + i, " ");
                if (item.equals(" ") || model.getIndexOf(item) != -1) continue;
                this.cmbFilter.addItem(item);
            }
            this.cmbFilter.setSelectedIndex(-1);
            if (this.cmbMappingVersion.getItemCount() > 0) {
                this.btnRefreshTables.setEnabled(true);
                this.cmbMappingVersion.setSelectedIndex(0);
            } else {
                this.btnRefreshTables.setEnabled(false);
            }
        }
        this.classSort.clear();
        this.methodSort.clear();
        this.paramSort.clear();
        this.fieldSort.clear();
        int i = this.prefs.getInt(PREFS_KEY_CLASS_SORT, 1);
        this.classSort.add(new RowSorter.SortKey(Math.abs(i) - 1, i > 0 ? SortOrder.ASCENDING : SortOrder.DESCENDING));
        this.tblClasses.getRowSorter().setSortKeys(this.classSort);
        i = this.prefs.getInt(PREFS_KEY_METHOD_SORT, 1);
        this.methodSort.add(new RowSorter.SortKey(Math.abs(i) - 1, i > 0 ? SortOrder.ASCENDING : SortOrder.DESCENDING));
        this.tblMethods.getRowSorter().setSortKeys(this.methodSort);
        i = this.prefs.getInt(PREFS_KEY_PARAM_SORT, 1);
        this.paramSort.add(new RowSorter.SortKey(Math.abs(i) - 1, i > 0 ? SortOrder.ASCENDING : SortOrder.DESCENDING));
        this.tblParams.getRowSorter().setSortKeys(this.paramSort);
        i = this.prefs.getInt(PREFS_KEY_FIELD_SORT, 1);
        this.fieldSort.add(new RowSorter.SortKey(Math.abs(i) - 1, i > 0 ? SortOrder.ASCENDING : SortOrder.DESCENDING));
        this.tblFields.getRowSorter().setSortKeys(this.fieldSort);
    }

    private void checkForUpdates() {
        this.versionChecker = new AppVersionChecker("MCP Mapping Viewer", VERSION_NUMBER, "http://bspk.rs/Minecraft/MMV/MMV.version", "http://www.minecraftforum.net/topic/2115030-", new String[]{"{appName} {oldVer} is out of date! Visit {updateURL} to download the latest release ({newVer})."}, new String[]{"{appName} {oldVer} is out of date! <br/><br/>Download the latest release ({newVer}) from <a href=\"{updateURL}\">{updateURL}</a>."}, 5000);
        if (!this.versionChecker.isCurrentVersion()) {
            MappingGui.showHTMLDialog(this, this.versionChecker.getDialogMessage()[0], "An update is available", 1);
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    MappingGui window = new MappingGui();
                    window.frmMcpMappingViewer.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private static String getPrintableStackTrace(Throwable e, Set<StackTraceElement> stopAt) {
        String s = e.toString();
        int numPrinted = 0;
        for (StackTraceElement ste : e.getStackTrace()) {
            boolean stopHere = false;
            if (stopAt.contains(ste) && numPrinted > 0) {
                stopHere = true;
            } else {
                s = s + "\n    at " + ste.toString();
                ++numPrinted;
                if (ste.getClassName().startsWith("javax.swing.")) {
                    stopHere = true;
                }
            }
            if (!stopHere) continue;
            int numHidden = e.getStackTrace().length - numPrinted;
            s = s + "\n    ... " + numHidden + " more";
            break;
        }
        return s;
    }

    private static String getStackTraceMessage(String prefix, Throwable e) {
        String s = prefix;
        s = s + "\n" + MappingGui.getPrintableStackTrace(e, Collections.emptySet());
        while (e.getCause() != null) {
            HashSet<StackTraceElement> stopAt = new HashSet<StackTraceElement>(Arrays.asList(e.getStackTrace()));
            e = e.getCause();
            s = s + "\nCaused by: " + MappingGui.getPrintableStackTrace(e, stopAt);
        }
        return s;
    }

    public MappingGui() {
        this.initialize();
        this.checkForUpdates();
    }

    public void setCsvFileEdited(boolean bol) {
        this.btnSave.setEnabled(bol);
        this.btnGetBotCommands.setEnabled(bol);
    }

    private void initialize() {
        this.frmMcpMappingViewer = new JFrame();
        this.frmMcpMappingViewer.setIconImage(new ImageIcon(MappingGui.class.getResource("/bspkrs/mmv/gui/icon/bspkrs32.png")).getImage());
        this.frmMcpMappingViewer.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                MappingGui.this.savePrefs();
            }
        });
        this.frmMcpMappingViewer.setTitle("MCP Mapping Viewer");
        this.frmMcpMappingViewer.setBounds(100, 100, 925, 621);
        this.frmMcpMappingViewer.setDefaultCloseOperation(3);
        this.frmMcpMappingViewer.getContentPane().setLayout(new BorderLayout(0, 0));
        JSplitPane splitMain = new JSplitPane();
        splitMain.setBorder(null);
        splitMain.setDividerSize(3);
        splitMain.setResizeWeight(0.5);
        splitMain.setContinuousLayout(true);
        splitMain.setMinimumSize(new Dimension(179, 80));
        splitMain.setPreferredSize(new Dimension(179, 80));
        splitMain.setOrientation(0);
        JScrollPane scrlpnClasses = new JScrollPane();
        scrlpnClasses.setVerticalScrollBarPolicy(22);
        splitMain.setLeftComponent(scrlpnClasses);
        this.tblClasses = new JTable();
        this.tblClasses.setAutoResizeMode(0);
        scrlpnClasses.setViewportView(this.tblClasses);
        this.tblClasses.setSelectionMode(0);
        this.tblClasses.getSelectionModel().addListSelectionListener(new ClassTableSelectionListener(this.tblClasses));
        this.tblClasses.setAutoCreateRowSorter(true);
        this.tblClasses.setEnabled(false);
        this.tblClasses.setModel(classesDefaultModel);
        this.tblClasses.setFillsViewportHeight(true);
        this.tblClasses.setCellSelectionEnabled(true);
        this.frmMcpMappingViewer.getContentPane().add((Component)splitMain, "Center");
        JSplitPane splitMembers = new JSplitPane();
        splitMembers.setBorder(null);
        splitMembers.setDividerSize(3);
        splitMembers.setResizeWeight(0.5);
        splitMembers.setOrientation(0);
        splitMain.setRightComponent(splitMembers);
        this.splitMethods = new JSplitPane();
        this.splitMethods.setBorder(null);
        this.splitMethods.setDividerSize(3);
        this.splitMethods.setResizeWeight(0.5);
        splitMembers.setLeftComponent(this.splitMethods);
        JScrollPane scrlpnMethods = new JScrollPane();
        scrlpnMethods.setVerticalScrollBarPolicy(22);
        this.splitMethods.setLeftComponent(scrlpnMethods);
        this.tblMethods = new JTable();
        this.tblMethods.setAutoResizeMode(0);
        this.tblMethods.getSelectionModel().addListSelectionListener(new MethodTableSelectionListener(this.tblMethods));
        this.tblMethods.setCellSelectionEnabled(true);
        this.tblMethods.setFillsViewportHeight(true);
        this.tblMethods.setAutoCreateRowSorter(true);
        this.tblMethods.setEnabled(false);
        this.tblMethods.setModel(methodsDefaultModel);
        scrlpnMethods.setViewportView(this.tblMethods);
        JScrollPane scrlpnParams = new JScrollPane();
        scrlpnParams.setVerticalScrollBarPolicy(22);
        this.splitMethods.setRightComponent(scrlpnParams);
        this.tblParams = new JTable();
        this.tblParams.setAutoResizeMode(0);
        this.tblParams.setCellSelectionEnabled(true);
        this.tblParams.setFillsViewportHeight(true);
        this.tblParams.setAutoCreateRowSorter(true);
        this.tblParams.setEnabled(false);
        this.tblParams.setModel(paramsDefaultModel);
        scrlpnParams.setViewportView(this.tblParams);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MappingGui.this.splitMethods.setDividerLocation(0.8);
            }
        });
        JScrollPane scrlpnFields = new JScrollPane();
        scrlpnFields.setVerticalScrollBarPolicy(22);
        splitMembers.setRightComponent(scrlpnFields);
        this.tblFields = new JTable();
        this.tblFields.setCellSelectionEnabled(true);
        this.tblFields.setAutoResizeMode(0);
        this.tblFields.setAutoCreateRowSorter(true);
        this.tblFields.setEnabled(false);
        this.tblFields.setModel(fieldsDefaultModel);
        this.tblFields.setFillsViewportHeight(true);
        scrlpnFields.setViewportView(this.tblFields);
        JPanel pnlHeader = new JPanel();
        this.frmMcpMappingViewer.getContentPane().add((Component)pnlHeader, "North");
        pnlHeader.setLayout(new BorderLayout(0, 0));
        JPanel pnlControls = new JPanel();
        pnlHeader.add((Component)pnlControls, "North");
        pnlControls.setSize(new Dimension(0, 40));
        pnlControls.setLayout(new FlowLayout(0, 5, 2));
        this.cmbMappingVersion = new JComboBox(new DefaultComboBoxModel());
        this.cmbMappingVersion.setEditable(false);
        this.cmbMappingVersion.setPreferredSize(new Dimension(320, 20));
        this.cmbMappingVersion.addItemListener(new MappingVersionsComboItemChanged());
        JLabel lblMappingVersion = new JLabel("Mapping Version");
        pnlControls.add(lblMappingVersion);
        pnlControls.add(this.cmbMappingVersion);
        this.btnGetVersions = new JButton("Get Versions");
        this.btnGetVersions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MappingGui.this.cmbMappingVersion.removeAllItems();
                    for (String s : MappingGui.this.versionFetcher.getVersions(MappingGui.this.chkForceRefresh.isSelected())) {
                        MappingGui.this.cmbMappingVersion.addItem(s);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        pnlControls.add(this.btnGetVersions);
        this.btnRefreshTables = new JButton("Load Mappings");
        this.btnRefreshTables.setEnabled(false);
        this.btnRefreshTables.addActionListener(new RefreshActionListener());
        pnlControls.add(this.btnRefreshTables);
        this.chkForceRefresh = new JCheckBox("Force reload");
        this.chkForceRefresh.setToolTipText("Force a reload from the MCP conf folder files instead of the session cache.");
        pnlControls.add(this.chkForceRefresh);
        this.pnlProgress = new JPanel();
        this.pnlProgress.setVisible(false);
        pnlHeader.add((Component)this.pnlProgress, "South");
        this.pnlProgress.setLayout(new BorderLayout(0, 0));
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.progressBar.setString("");
        this.progressBar.setForeground(UIManager.getColor("ProgressBar.foreground"));
        this.pnlProgress.add(this.progressBar);
        this.pnlFilter = new JPanel();
        FlowLayout flowLayout = (FlowLayout)this.pnlFilter.getLayout();
        flowLayout.setVgap(2);
        flowLayout.setAlignment(0);
        this.pnlFilter.setVisible(true);
        pnlHeader.add((Component)this.pnlFilter, "Center");
        JLabel lblFilter = new JLabel("Search");
        this.pnlFilter.add(lblFilter);
        this.cmbFilter = new JComboBox();
        this.cmbFilter.setEditable(true);
        this.cmbFilter.setPreferredSize(new Dimension(300, 20));
        this.cmbFilter.setMaximumRowCount(10);
        this.pnlFilter.add(this.cmbFilter);
        this.btnSearch = new JButton("Go");
        this.btnSearch.setToolTipText("");
        this.btnSearch.addActionListener(new SearchActionListener());
        this.pnlFilter.add(this.btnSearch);
        this.cmbFilter.setEnabled(false);
        this.cmbFilter.addActionListener(new FilterComboTextEdited());
        this.cmbFilter.getEditor().getEditorComponent().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                MappingGui.this.cmbFilter.getEditor().selectAll();
            }
        });
        this.cmbFilter.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    MappingGui.this.btnSearch.doClick();
                }
            }
        });
        this.btnSearch.setEnabled(false);
        JLabel lblSearchInfo = new JLabel("A note on search");
        lblSearchInfo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String message = "Search is global and returns a set of classes that contain a match for the input. \nSearch is case sensitive!\n\nData elements searched on:\nClasses:\n    ~ Pkg Name\n    ~ SRG Name\n    ~ Obf Name\nMethods/Fields:\n    ~ SRG Name\n    ~ Obf Name\n    ~ MCP Name\n    ~ Comment\n\nParameters are not currently searchable.";
                JOptionPane.showMessageDialog(MappingGui.this, message, "Search Info", 1);
            }
        });
        lblSearchInfo.setCursor(Cursor.getPredefinedCursor(12));
        lblSearchInfo.setForeground(Color.BLUE);
        this.pnlFilter.add(lblSearchInfo);
        JSeparator separator = new JSeparator();
        separator.setPreferredSize(new Dimension(1, 12));
        separator.setOrientation(1);
        this.pnlFilter.add(separator);
        JLabel lblAbout = new JLabel("About");
        this.pnlFilter.add(lblAbout);
        lblAbout.setForeground(Color.BLUE);
        lblAbout.setCursor(Cursor.getPredefinedCursor(12));
        JSeparator separator_1 = new JSeparator();
        separator_1.setPreferredSize(new Dimension(1, 12));
        separator_1.setOrientation(1);
        this.pnlFilter.add(separator_1);
        this.btnGetBotCommands = new JButton("Get Command List");
        this.btnGetBotCommands.setToolTipText("Exports to the system clipboard a listing of MCPBot commands for any edits you have made in the GUI.");
        this.btnGetBotCommands.setEnabled(false);
        this.btnGetBotCommands.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String commands = MappingGui.this.currentLoader.getBotCommands(MappingGui.this.chkClearOnCopy.isSelected());
                if (commands != null && !commands.isEmpty()) {
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(commands), null);
                    JOptionPane.showMessageDialog(MappingGui.this, "Commands copied to clipboard: \n" + commands, "MMV - MCPBot Commands", 1);
                    if (MappingGui.this.chkClearOnCopy.isSelected()) {
                        MappingGui.this.btnGetBotCommands.setEnabled(false);
                    }
                } else {
                    JOptionPane.showMessageDialog(MappingGui.this, "No commands to copy.", "MMV - MCPBot Commands", 1);
                }
                MappingGui.this.chkClearOnCopy.setSelected(false);
            }
        });
        this.pnlFilter.add(this.btnGetBotCommands);
        this.chkClearOnCopy = new JCheckBox("Clear");
        this.chkClearOnCopy.setToolTipText("Whether or not to clear the MCPBot command list when the button is clicked.");
        this.pnlFilter.add(this.chkClearOnCopy);
        lblAbout.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MappingGui.class.getClassLoader();
                String imgsrc = MappingGui.class.getResource("/bspkrs/mmv/gui/icon/bspkrs.png").toString();
                String year = new SimpleDateFormat("yyyy").format(new Date());
                String message = "<center><img src=\"" + imgsrc + "\"/><br/>" + "MCP Mapping Viewer v" + MappingGui.VERSION_NUMBER + "<br/>" + "Copyright (C) 2013-" + year + " bspkrs<br/>" + "Portions Copyright (C) 2013 Alex \"immibis\" Campbell<br/><br/>" + "Author: bspkrs<br/>" + "Credits: immibis (for <a href=\"https://github.com/immibis/bearded-octo-nemesis\">BON</a> code), " + "Searge et al (for <a href=\"http://mcp.ocean-labs.de\">MCP</a>)<br/><br/>" + "<a href=\"" + "http://www.minecraftforum.net/topic/2115030-" + "\">MCF Thread</a><br/>" + "<a href=\"https://github.com/bspkrs/MCPMappingViewer\">Github Repo</a><br/>" + "<a href=\"https://github.com/bspkrs/MCPMappingViewer/blob/master/change.log\">Change Log</a><br/>" + "<a href=\"http://bspk.rs/MC/MCPMappingViewer/index.html\">Binary Downloads</a><br/>" + "<a href=\"https://raw.githubusercontent.com/bspkrs/MCPMappingViewer/master/LICENSE\">License</a><br/>" + "<a href=\"https://raw.githubusercontent.com/google/gson/master/LICENSE\">GSON License</a><br/>" + "<a href=\"https://twitter.com/bspkrs\">bspkrs on Twitter</a></center>";
                MappingGui.showHTMLDialog(MappingGui.this, message, "About MCP Mapping Viewer", -1);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MappingGui.this.savePrefs();
            }
        });
        try {
            this.loadPrefs(false);
        }
        catch (Throwable e) {
            String s = MappingGui.getStackTraceMessage("An error has occurred - give bspkrs this stack trace (which has been copied to the clipboard) if the error continues to occur on launch.\n", e);
            System.err.println(s);
            final String errMsg = s;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MappingGui.this.progressBar.setString(" ");
                    MappingGui.this.progressBar.setValue(0);
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(errMsg), null);
                    JOptionPane.showMessageDialog(MappingGui.this, errMsg, "MMV - Error", 0);
                }
            });
        }
    }

    public static void showHTMLDialog(Component parentComponent, Object message, String title, int messageType) {
        JLabel label = new JLabel();
        Font font = label.getFont();
        StringBuffer style = new StringBuffer("font-family:" + font.getFamily() + ";");
        style.append("font-weight:" + (font.isBold() ? "bold" : "normal") + ";");
        style.append("font-size:" + font.getSize() + "pt;");
        JEditorPane ep = new JEditorPane("text/html", "<html><body style=\"" + style + "\">" + message.toString() + "</body></html>");
        ep.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    try {
                        Desktop.getDesktop().browse(e.getURL().toURI());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        });
        ep.setSize(100, 100);
        ep.setEditable(false);
        ep.setBackground(label.getBackground());
        JOptionPane.showMessageDialog(parentComponent, ep, title, messageType);
    }

    class RefreshActionListener
    implements ActionListener {
        RefreshActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MappingGui.this.curTask != null && MappingGui.this.curTask.isAlive()) {
                return;
            }
            final String mappingVersion = (String)MappingGui.this.cmbMappingVersion.getSelectedItem();
            MappingGui.this.savePrefs();
            MappingGui.this.pnlFilter.setVisible(false);
            MappingGui.this.pnlProgress.setVisible(true);
            MappingGui.this.tblClasses.setModel(classesDefaultModel);
            MappingGui.this.tblClasses.setEnabled(false);
            MappingGui.this.tblMethods.setModel(methodsDefaultModel);
            MappingGui.this.tblMethods.setEnabled(false);
            MappingGui.this.tblParams.setModel(paramsDefaultModel);
            MappingGui.this.tblParams.setEnabled(false);
            MappingGui.this.tblFields.setModel(fieldsDefaultModel);
            MappingGui.this.tblFields.setEnabled(false);
            MappingGui.this.loadPrefs(true);
            MappingGui.this.curTask = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                @Override
                public void run() {
                    block9: {
                        boolean crashed = false;
                        try {
                            IProgressListener progress = new IProgressListener(){
                                private String currentText;

                                @Override
                                public void start(final int max, String text) {
                                    this.currentText = text.equals("") ? " " : text;
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            MappingGui.this.progressBar.setString(currentText);
                                            if (max >= 0) {
                                                MappingGui.this.progressBar.setMaximum(max);
                                            }
                                            MappingGui.this.progressBar.setValue(0);
                                        }
                                    });
                                }

                                @Override
                                public void set(final int value) {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            MappingGui.this.progressBar.setValue(value);
                                        }
                                    });
                                }

                                @Override
                                public void set(final int value, String text) {
                                    this.currentText = text.equals("") ? " " : text;
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            MappingGui.this.progressBar.setValue(value);
                                            MappingGui.this.progressBar.setString(currentText);
                                        }
                                    });
                                }

                                @Override
                                public void setMax(final int max) {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            MappingGui.this.progressBar.setMaximum(max);
                                        }
                                    });
                                }
                            };
                            if (!MappingGui.this.mcpInstances.containsKey(mappingVersion) || MappingGui.this.chkForceRefresh.isSelected()) {
                                progress.start(0, "Reading MCP configuration");
                                MappingGui.this.currentLoader = new McpMappingLoader(MappingGui.this, mappingVersion, progress);
                                MappingGui.this.mcpInstances.put(mappingVersion, MappingGui.this.currentLoader);
                                MappingGui.this.chkForceRefresh.setSelected(false);
                            } else {
                                MappingGui.this.currentLoader = (McpMappingLoader)MappingGui.this.mcpInstances.get(mappingVersion);
                            }
                            MappingGui.this.tblClasses.setModel(MappingGui.this.currentLoader.getClassModel());
                            MappingGui.this.tblClasses.setEnabled(true);
                            new TableColumnAdjuster(MappingGui.this.tblClasses).adjustColumns();
                            MappingGui.this.loadPrefs(true);
                            if (crashed) break block9;
                        }
                        catch (McpMappingLoader.CantLoadMCPMappingException e) {
                            block10: {
                                String s = MappingGui.getStackTraceMessage("", e);
                                System.err.println(s);
                                crashed = true;
                                final String errMsg = s;
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        MappingGui.this.progressBar.setString(" ");
                                        MappingGui.this.progressBar.setValue(0);
                                        JOptionPane.showMessageDialog(MappingGui.this, errMsg, "MMV - Error", 0);
                                    }
                                });
                                if (crashed) break block10;
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        MappingGui.this.progressBar.setString(" ");
                                        MappingGui.this.progressBar.setValue(0);
                                        MappingGui.this.cmbFilter.setEnabled(true);
                                    }
                                });
                            }
                            MappingGui.this.pnlProgress.setVisible(false);
                            MappingGui.this.pnlFilter.setVisible(true);
                            MappingGui.this.cmbFilter.setEnabled(true);
                            MappingGui.this.btnSearch.setEnabled(true);
                            MappingGui.this.btnGetBotCommands.setEnabled(MappingGui.this.currentLoader.hasPendingCommands());
                        }
                        catch (Exception e2) {
                            block11: {
                                String s = MappingGui.getStackTraceMessage("An error has occurred - give bspkrs this stack trace (which has been copied to the clipboard)\n", e2);
                                System.err.println(s);
                                crashed = true;
                                final String errMsg = s;
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        MappingGui.this.progressBar.setString(" ");
                                        MappingGui.this.progressBar.setValue(0);
                                        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(errMsg), null);
                                        JOptionPane.showMessageDialog(MappingGui.this, errMsg, "MMV - Error", 0);
                                    }
                                });
                                if (crashed) break block11;
                                {
                                    catch (Throwable throwable) {
                                        if (!crashed) {
                                            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                        }
                                        MappingGui.this.pnlProgress.setVisible(false);
                                        MappingGui.this.pnlFilter.setVisible(true);
                                        MappingGui.this.cmbFilter.setEnabled(true);
                                        MappingGui.this.btnSearch.setEnabled(true);
                                        MappingGui.this.btnGetBotCommands.setEnabled(MappingGui.this.currentLoader.hasPendingCommands());
                                        throw throwable;
                                    }
                                }
                                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                            }
                            MappingGui.this.pnlProgress.setVisible(false);
                            MappingGui.this.pnlFilter.setVisible(true);
                            MappingGui.this.cmbFilter.setEnabled(true);
                            MappingGui.this.btnSearch.setEnabled(true);
                            MappingGui.this.btnGetBotCommands.setEnabled(MappingGui.this.currentLoader.hasPendingCommands());
                        }
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                    MappingGui.this.pnlProgress.setVisible(false);
                    MappingGui.this.pnlFilter.setVisible(true);
                    MappingGui.this.cmbFilter.setEnabled(true);
                    MappingGui.this.btnSearch.setEnabled(true);
                    MappingGui.this.btnGetBotCommands.setEnabled(MappingGui.this.currentLoader.hasPendingCommands());
                }
            };
            MappingGui.this.curTask.start();
        }
    }

    class SearchActionListener
    implements ActionListener {
        SearchActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MappingGui.this.curTask != null && MappingGui.this.curTask.isAlive() || MappingGui.this.cmbFilter.getItemCount() == 0) {
                return;
            }
            String filterText = MappingGui.this.cmbFilter.getSelectedItem().toString();
            if (filterText != null && !filterText.trim().isEmpty()) {
                DefaultComboBoxModel model = (DefaultComboBoxModel)MappingGui.this.cmbFilter.getModel();
                if (model.getIndexOf(filterText) != -1) {
                    model.removeElement(filterText);
                }
                MappingGui.this.cmbFilter.insertItemAt(filterText, 0);
                MappingGui.this.cmbFilter.setSelectedItem(filterText);
            }
            MappingGui.this.savePrefs();
            MappingGui.this.cmbFilter.setEnabled(false);
            MappingGui.this.btnSearch.setEnabled(false);
            MappingGui.this.pnlProgress.setVisible(true);
            MappingGui.this.tblClasses.setModel(classesDefaultModel);
            MappingGui.this.tblClasses.setEnabled(false);
            MappingGui.this.tblMethods.setModel(methodsDefaultModel);
            MappingGui.this.tblMethods.setEnabled(false);
            MappingGui.this.tblParams.setModel(paramsDefaultModel);
            MappingGui.this.tblParams.setEnabled(false);
            MappingGui.this.tblFields.setModel(fieldsDefaultModel);
            MappingGui.this.tblFields.setEnabled(false);
            MappingGui.this.loadPrefs(true);
            MappingGui.this.curTask = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block12: {
                        boolean crashed = false;
                        try {
                            IProgressListener progress = new IProgressListener(){
                                private String currentText;

                                @Override
                                public void start(final int max, String text) {
                                    this.currentText = text.equals("") ? " " : text;
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            MappingGui.this.progressBar.setString(currentText);
                                            if (max >= 0) {
                                                MappingGui.this.progressBar.setMaximum(max);
                                            }
                                            MappingGui.this.progressBar.setValue(0);
                                        }
                                    });
                                }

                                @Override
                                public void set(final int value) {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            MappingGui.this.progressBar.setValue(value);
                                        }
                                    });
                                }

                                @Override
                                public void set(final int value, String text) {
                                    this.currentText = text.equals("") ? " " : text;
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            MappingGui.this.progressBar.setValue(value);
                                            MappingGui.this.progressBar.setString(currentText);
                                        }
                                    });
                                }

                                @Override
                                public void setMax(final int max) {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            MappingGui.this.progressBar.setMaximum(max);
                                        }
                                    });
                                }
                            };
                            progress.start(0, "Searching MCP objects for input");
                            MappingGui.this.tblClasses.setModel(MappingGui.this.currentLoader.getSearchResults(MappingGui.this.cmbFilter.getSelectedItem().toString(), progress));
                            MappingGui.this.tblClasses.setEnabled(true);
                            new TableColumnAdjuster(MappingGui.this.tblClasses).adjustColumns();
                            MappingGui.this.loadPrefs(true);
                            if (MappingGui.this.tblClasses.getRowCount() > 0) {
                                String pkg = (String)MappingGui.this.tblClasses.getModel().getValueAt(0, 0);
                                String name = (String)MappingGui.this.tblClasses.getModel().getValueAt(0, 1);
                                MappingGui.this.tblMethods.setModel(MappingGui.this.currentLoader.getMethodModel(pkg + "/" + name));
                                MappingGui.this.tblMethods.setEnabled(true);
                                MappingGui.this.tblFields.setModel(MappingGui.this.currentLoader.getFieldModel(pkg + "/" + name));
                                MappingGui.this.tblFields.setEnabled(true);
                                MappingGui.this.tblParams.setModel(paramsDefaultModel);
                                MappingGui.this.tblParams.setEnabled(true);
                                new TableColumnAdjuster(MappingGui.this.tblMethods).adjustColumns();
                                new TableColumnAdjuster(MappingGui.this.tblFields).adjustColumns();
                                MappingGui.this.loadPrefs(true);
                                if (MappingGui.this.cmbFilter.getSelectedItem().toString().trim().startsWith("field") && MappingGui.this.tblFields.getRowCount() > 0) {
                                    for (int i = 0; i < MappingGui.this.tblFields.getRowCount(); ++i) {
                                        if (!((String)MappingGui.this.tblFields.getModel().getValueAt(i, 1)).contains(MappingGui.this.cmbFilter.getSelectedItem().toString())) continue;
                                        final int rowIndex = i;
                                        MappingGui.this.tblFields.setRowSelectionInterval(rowIndex, rowIndex);
                                        MappingGui.this.tblFields.setColumnSelectionInterval(1, 1);
                                        MappingGui.this.tblFields.requestFocus();
                                        SwingUtilities.invokeLater(new Runnable(){

                                            @Override
                                            public void run() {
                                                MappingGui.this.tblFields.scrollRectToVisible(MappingGui.this.tblFields.getCellRect(rowIndex, 0, true));
                                            }
                                        });
                                        break;
                                    }
                                } else if (MappingGui.this.cmbFilter.getSelectedItem().toString().trim().startsWith("func") && MappingGui.this.tblMethods.getRowCount() > 0) {
                                    for (int i = 0; i < MappingGui.this.tblMethods.getRowCount(); ++i) {
                                        if (!((String)MappingGui.this.tblMethods.getModel().getValueAt(i, 1)).contains(MappingGui.this.cmbFilter.getSelectedItem().toString())) continue;
                                        final int rowIndex = i;
                                        MappingGui.this.tblMethods.setRowSelectionInterval(rowIndex, rowIndex);
                                        MappingGui.this.tblMethods.setColumnSelectionInterval(1, 1);
                                        MappingGui.this.tblMethods.requestFocus();
                                        SwingUtilities.invokeLater(new Runnable(){

                                            @Override
                                            public void run() {
                                                MappingGui.this.tblMethods.scrollRectToVisible(MappingGui.this.tblMethods.getCellRect(rowIndex, 0, true));
                                            }
                                        });
                                        break;
                                    }
                                }
                            }
                            MappingGui.this.loadPrefs(true);
                            if (crashed) break block12;
                        }
                        catch (Exception e) {
                            block13: {
                                try {
                                    String s = MappingGui.getStackTraceMessage("An error has occurred - give bspkrs this stack trace (which has been copied to the clipboard)\n", e);
                                    System.err.println(s);
                                    crashed = true;
                                    final String errMsg = s;
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            MappingGui.this.progressBar.setString(" ");
                                            MappingGui.this.progressBar.setValue(0);
                                            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(errMsg), null);
                                            JOptionPane.showMessageDialog(MappingGui.this, errMsg, "MMV - Error", 0);
                                        }
                                    });
                                    if (crashed) break block13;
                                }
                                catch (Throwable throwable) {
                                    if (!crashed) {
                                        SwingUtilities.invokeLater(new Runnable(){

                                            @Override
                                            public void run() {
                                                MappingGui.this.progressBar.setString(" ");
                                                MappingGui.this.progressBar.setValue(0);
                                                MappingGui.this.cmbFilter.setEnabled(true);
                                            }
                                        });
                                    }
                                    MappingGui.this.pnlProgress.setVisible(false);
                                    MappingGui.this.cmbFilter.setEnabled(true);
                                    MappingGui.this.btnSearch.setEnabled(true);
                                    throw throwable;
                                }
                                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                            }
                            MappingGui.this.pnlProgress.setVisible(false);
                            MappingGui.this.cmbFilter.setEnabled(true);
                            MappingGui.this.btnSearch.setEnabled(true);
                        }
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                    MappingGui.this.pnlProgress.setVisible(false);
                    MappingGui.this.cmbFilter.setEnabled(true);
                    MappingGui.this.btnSearch.setEnabled(true);
                }
            };
            MappingGui.this.curTask.start();
        }
    }

    class MethodTableSelectionListener
    implements ListSelectionListener {
        private final JTable table;

        public MethodTableSelectionListener(JTable table) {
            this.table = table;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting() && !this.table.getModel().equals(methodsDefaultModel)) {
                int i = this.table.getSelectedRow();
                if (i > -1) {
                    MappingGui.this.savePrefs();
                    String name = (String)this.table.getModel().getValueAt(this.table.convertRowIndexToModel(i), 1);
                    MappingGui.this.tblParams.setModel(MappingGui.this.currentLoader.getParamModel(name));
                    MappingGui.this.tblParams.setEnabled(true);
                    new TableColumnAdjuster(MappingGui.this.tblParams).adjustColumns();
                    MappingGui.this.loadPrefs(true);
                } else {
                    MappingGui.this.tblParams.setModel(paramsDefaultModel);
                    MappingGui.this.tblParams.setEnabled(false);
                }
            }
        }
    }

    class ClassTableSelectionListener
    implements ListSelectionListener {
        private final JTable table;

        public ClassTableSelectionListener(JTable table) {
            this.table = table;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting() && !this.table.getModel().equals(classesDefaultModel)) {
                int i = this.table.getSelectedRow();
                if (i > -1) {
                    MappingGui.this.savePrefs();
                    String pkg = (String)this.table.getModel().getValueAt(this.table.convertRowIndexToModel(i), 0);
                    String name = (String)this.table.getModel().getValueAt(this.table.convertRowIndexToModel(i), 1);
                    MappingGui.this.tblMethods.setModel(MappingGui.this.currentLoader.getMethodModel(pkg + "/" + name));
                    MappingGui.this.tblMethods.setEnabled(true);
                    MappingGui.this.tblFields.setModel(MappingGui.this.currentLoader.getFieldModel(pkg + "/" + name));
                    MappingGui.this.tblFields.setEnabled(true);
                    MappingGui.this.tblParams.setModel(paramsDefaultModel);
                    MappingGui.this.tblParams.setEnabled(true);
                    new TableColumnAdjuster(MappingGui.this.tblMethods).adjustColumns();
                    new TableColumnAdjuster(MappingGui.this.tblFields).adjustColumns();
                    MappingGui.this.loadPrefs(true);
                } else {
                    MappingGui.this.tblMethods.setModel(methodsDefaultModel);
                    MappingGui.this.tblMethods.setEnabled(false);
                    MappingGui.this.tblFields.setModel(fieldsDefaultModel);
                    MappingGui.this.tblFields.setEnabled(false);
                    MappingGui.this.tblParams.setModel(paramsDefaultModel);
                    MappingGui.this.tblParams.setEnabled(false);
                }
            }
        }
    }

    class FilterComboTextEdited
    implements ActionListener {
        FilterComboTextEdited() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("comboBoxEdited")) {
                String filterText = MappingGui.this.cmbFilter.getSelectedItem().toString();
                if (filterText == null || filterText.trim().isEmpty()) {
                    return;
                }
                DefaultComboBoxModel model = (DefaultComboBoxModel)MappingGui.this.cmbFilter.getModel();
                if (model.getIndexOf(filterText) != -1) {
                    model.removeElement(filterText);
                }
                MappingGui.this.cmbFilter.insertItemAt(filterText, 0);
                MappingGui.this.cmbFilter.setSelectedItem(filterText);
            }
        }
    }

    class MappingVersionsComboItemChanged
    implements ItemListener {
        MappingVersionsComboItemChanged() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                JComboBox cmb = (JComboBox)e.getSource();
                MappingGui.this.btnRefreshTables.setEnabled(cmb.getItemCount() > 0);
            }
        }
    }
}

