/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.mmv;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExcData
implements Comparable<ExcData> {
    private final String srgOwner;
    private final String srgName;
    private final String descriptor;
    private final String[] exceptions;
    private final String[] parameters;
    private final String[] paramTypes;

    public ExcData(String srgOwner, String srgName, String descriptor, String[] exceptions, String[] parameters) {
        this.srgOwner = srgOwner;
        this.srgName = srgName;
        this.descriptor = descriptor;
        this.exceptions = exceptions;
        this.paramTypes = ExcData.splitMethodDesc(descriptor);
        this.parameters = parameters;
    }

    public ExcData(String srgOwner, String srgName, String descriptor, String[] exceptions, boolean isStatic) {
        this.srgOwner = srgOwner;
        this.srgName = srgName;
        this.descriptor = descriptor;
        this.exceptions = exceptions;
        this.paramTypes = ExcData.splitMethodDesc(descriptor);
        this.parameters = ExcData.genParamNames(ExcData.getSrgId(srgName), this.paramTypes, isStatic);
    }

    public String getSrgClassOwner() {
        return this.srgOwner;
    }

    public String getSrgMethodName() {
        return this.srgName;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public String[] getExceptions() {
        return this.exceptions;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public String[] getParamTypes() {
        return this.paramTypes;
    }

    public boolean contains(String s) {
        if (this.srgName.contains(s)) {
            return true;
        }
        for (String param : this.parameters) {
            if (!param.contains(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(ExcData o) {
        return this.srgName.compareTo(o.srgName);
    }

    public static String[] splitMethodDesc(String desc) {
        int beginIndex = desc.indexOf(40);
        int endIndex = desc.lastIndexOf(41);
        if (beginIndex == -1 && endIndex != -1 || beginIndex != -1 && endIndex == -1) {
            System.err.println(beginIndex);
            System.err.println(endIndex);
            throw new RuntimeException();
        }
        String x0 = beginIndex == -1 && endIndex == -1 ? desc : desc.substring(beginIndex + 1, endIndex);
        Pattern pattern = Pattern.compile("\\[*L[^;]+;|\\[[ZBCSIFDJ]|[ZBCSIFDJ]");
        Matcher matcher = pattern.matcher(x0);
        ArrayList<String> listMatches = new ArrayList<String>();
        while (matcher.find()) {
            listMatches.add(matcher.group());
        }
        return listMatches.toArray(new String[listMatches.size()]);
    }

    public static String[] genParamNames(String srgId, String[] paramTypes, boolean isStatic) {
        int idOffset;
        boolean skip2 = paramTypes.length >= 4 && paramTypes[0].equals("Ljava/lang/String;") && paramTypes[1].equals(Character.valueOf('I')) && paramTypes[0].equals(paramTypes[2]) && paramTypes[1].equals(paramTypes[3]);
        String[] ret = new String[paramTypes.length];
        int n = idOffset = isStatic ? 0 : 1;
        if (skip2) {
            idOffset += 2;
        }
        for (int i = 0; i < paramTypes.length; ++i) {
            ret[i] = "p_" + srgId + "_" + (i + idOffset) + "_";
            if (!paramTypes[i].equals("D") && !paramTypes[i].equals("J")) continue;
            ++idOffset;
        }
        return ret;
    }

    public static String getSrgId(String srgName) {
        Pattern pattern = Pattern.compile("func_(i?[0-9]+)_");
        Matcher matcher = pattern.matcher(srgName);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return srgName;
    }

    public String toString() {
        return String.format("  Owner: %s\n  SRG Name: %s\n  Descriptor: %s\n  Exceptions: %s\n  Parameters: %s\n  Param Types: %s", this.srgOwner, this.srgName, this.descriptor, Arrays.toString(this.exceptions), Arrays.toString(this.parameters), Arrays.toString(this.paramTypes));
    }
}

