/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.mmv;

import bspkrs.mmv.ParamCsvData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;

public class ParamCsvFile {
    private final File file;
    private final Map<String, ParamCsvData> srgParamName2ParamCsvData;
    private boolean isDirty;
    private String headerLine;

    public ParamCsvFile(File file) throws IOException {
        this.file = file;
        this.srgParamName2ParamCsvData = new TreeMap<String, ParamCsvData>();
        this.readFromFile();
        this.isDirty = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFromFile() throws IOException {
        try (Scanner in = new Scanner(new BufferedReader(new FileReader(this.file)));){
            in.useDelimiter(",");
            this.headerLine = in.nextLine();
            while (in.hasNextLine()) {
                String srgName = in.next();
                String mcpName = in.next();
                String side = in.nextLine().substring(1);
                this.srgParamName2ParamCsvData.put(srgName, new ParamCsvData(srgName, mcpName, Integer.valueOf(side)));
            }
        }
    }

    public void writeToFile() throws IOException {
        if (this.isDirty) {
            if (this.file.exists()) {
                File fileBak = new File(this.file.getAbsolutePath() + "_" + new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date()) + ".bak");
                this.file.renameTo(fileBak);
            }
            this.file.createNewFile();
            PrintWriter out = new PrintWriter(new FileWriter(this.file));
            out.println(this.headerLine);
            for (ParamCsvData data : this.srgParamName2ParamCsvData.values()) {
                out.println(data.toCsv());
            }
            out.close();
            this.isDirty = false;
        }
    }

    public boolean hasCsvDataForKey(String srgName) {
        return this.srgParamName2ParamCsvData.containsKey(srgName);
    }

    public ParamCsvData getCsvDataForKey(String srgName) {
        return this.srgParamName2ParamCsvData.get(srgName);
    }

    public void updateCsvDataForKey(String srgName, ParamCsvData csvData) {
        this.srgParamName2ParamCsvData.put(srgName, csvData);
        this.isDirty = true;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setIsDirty(boolean bol) {
        this.isDirty = bol;
    }
}

