/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.mmv;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class RemoteZipHandler {
    private final URL zipUrl;
    private final URL digestUrl;
    private final File localDir;
    private final String digestType;
    private final String zipFileName;

    public RemoteZipHandler(String urlString, File dir, String digestType) throws MalformedURLException {
        this.zipUrl = new URL(urlString);
        this.digestUrl = digestType != null ? new URL(urlString + "." + digestType.toLowerCase()) : null;
        String[] tokens = urlString.split("/");
        this.zipFileName = tokens[tokens.length - 1];
        this.localDir = dir;
        this.digestType = digestType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkRemoteZip() throws IOException, NoSuchAlgorithmException, DigestException {
        String existingHash;
        boolean fetchZip = true;
        String remoteHash = null;
        File digestFile = null;
        if (this.digestType != null && !(remoteHash = RemoteZipHandler.loadTextFromURL(this.digestUrl, new String[]{""})[0]).isEmpty() && (digestFile = new File(this.localDir, this.zipFileName + "." + this.digestType.toLowerCase())).exists() && !(existingHash = RemoteZipHandler.loadTextFromFile(digestFile, new String[]{""})[0]).isEmpty() && remoteHash.equals(existingHash)) {
            fetchZip = false;
        }
        if (fetchZip) {
            String downloadHash;
            File localZip = new File(this.localDir, this.zipFileName);
            if (localZip.exists()) {
                localZip.delete();
            }
            try (FileOutputStream output = new FileOutputStream(localZip);){
                URLConnection uc = this.zipUrl.openConnection();
                uc.addRequestProperty("User-Agent", "MMV/1.0.0");
                byte[] buffer = new byte[1024];
                try (InputStream is = uc.getInputStream();){
                    int bytesRead;
                    while ((bytesRead = is.read(buffer)) > 0) {
                        ((OutputStream)output).write(buffer, 0, bytesRead);
                    }
                }
            }
            if (this.digestType != null && !remoteHash.isEmpty() && !remoteHash.equals(downloadHash = RemoteZipHandler.getFileDigest(new FileInputStream(localZip), this.digestType))) {
                throw new DigestException("Remote digest does not match digest of downloaded file!");
            }
            RemoteZipHandler.extractZip(localZip, this.localDir);
            if (localZip.exists()) {
                localZip.delete();
            }
            if (this.digestType != null && !remoteHash.isEmpty()) {
                if (digestFile.exists()) {
                    digestFile.delete();
                }
                digestFile.createNewFile();
                PrintWriter out = new PrintWriter(new FileWriter(digestFile));
                out.print(remoteHash);
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] loadTextFromURL(URL url, String[] defaultValue) {
        ArrayList<String> arraylist = new ArrayList<String>();
        try (Scanner scanner = null;){
            URLConnection uc = url.openConnection();
            uc.addRequestProperty("User-Agent", "MMV/1.0.0");
            InputStream is = uc.getInputStream();
            scanner = new Scanner(is, "UTF-8");
            while (scanner.hasNextLine()) {
                arraylist.add(scanner.nextLine());
            }
        }
        return arraylist.toArray(new String[arraylist.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] loadTextFromFile(File file, String[] defaultValue) {
        ArrayList<String> lines = new ArrayList<String>();
        try (Scanner scanner = null;){
            scanner = new Scanner(file);
            while (scanner.hasNextLine()) {
                lines.add(scanner.nextLine());
            }
        }
        return lines.toArray(new String[lines.size()]);
    }

    public static String getFileDigest(InputStream is, String digestType) throws NoSuchAlgorithmException, IOException {
        MessageDigest md = MessageDigest.getInstance(digestType);
        byte[] dataBytes = new byte[1024];
        int nread = 0;
        while ((nread = is.read(dataBytes)) != -1) {
            md.update(dataBytes, 0, nread);
        }
        is.close();
        byte[] mdbytes = md.digest();
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < mdbytes.length; ++i) {
            sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractZip(File zipFile, File destDir) throws IOException {
        byte[] buffer = new byte[1024];
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));
        ZipEntry ze = zis.getNextEntry();
        try {
            while (ze != null) {
                String fileName = ze.getName();
                File newFile = new File(destDir, fileName);
                if (ze.isDirectory()) {
                    if (newFile.exists()) {
                        RemoteZipHandler.deleteDirAndContents(newFile);
                    }
                    newFile.mkdirs();
                } else {
                    int len;
                    if (newFile.exists()) {
                        newFile.delete();
                    }
                    FileOutputStream fos = new FileOutputStream(newFile);
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.close();
                }
                ze = zis.getNextEntry();
            }
        }
        finally {
            zis.closeEntry();
            zis.close();
        }
    }

    public static boolean deleteDirAndContents(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = RemoteZipHandler.deleteDirAndContents(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }
}

