/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.mmv.version;

import bspkrs.mmv.version.NaturalOrderComparator;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.prefs.Preferences;

public class AppVersionChecker {
    private URL versionURL;
    private final String appName;
    private String newVersion;
    private final String currentVersion;
    private String updateURL;
    private String[] logMsg;
    private String[] dialogMsg;
    private final Preferences versionCheckTracker;
    private final String LAST_VERSION_FOUND = "lastversionfound";
    private final String RUNS_SINCE_LAST_MSG = "runs_since_last_message";
    private final String CHECK_ERROR = "check_error";
    private String lastNewVersionFound;
    private final boolean errorDetected;
    private int runsSinceLastMessage;

    public AppVersionChecker(String appName, String currentVersion, String versionURL, String updateURL, String[] logMsg, String[] dialogMsg, int timeoutMS) {
        this.appName = appName;
        this.currentVersion = currentVersion;
        this.updateURL = updateURL;
        this.logMsg = logMsg;
        this.dialogMsg = dialogMsg;
        try {
            if (versionURL.startsWith("http://dl.dropboxusercontent.com")) {
                versionURL = versionURL.replaceFirst("http", "https");
            }
            this.versionURL = new URL(versionURL);
        }
        catch (Throwable ignore) {
            // empty catch block
        }
        String[] versionLines = AppVersionChecker.loadTextFromURL(this.versionURL, new String[]{"check_error"}, timeoutMS);
        this.newVersion = versionLines.length == 0 || versionLines[0].trim().equals("<html>") ? "check_error" : versionLines[0].trim();
        this.errorDetected = this.newVersion.equals("check_error");
        this.versionCheckTracker = Preferences.userNodeForPackage(AppVersionChecker.class);
        this.lastNewVersionFound = this.versionCheckTracker.get("lastversionfound", currentVersion);
        if (this.lastNewVersionFound.equals("<html>")) {
            this.lastNewVersionFound = currentVersion;
        }
        this.runsSinceLastMessage = this.versionCheckTracker.getInt("runs_since_last_message", 0);
        if (this.errorDetected) {
            this.newVersion = this.lastNewVersionFound;
        }
        if (!this.errorDetected && !AppVersionChecker.isCurrentVersion(this.lastNewVersionFound, this.newVersion)) {
            this.runsSinceLastMessage = 0;
            this.lastNewVersionFound = this.newVersion;
        } else {
            this.runsSinceLastMessage %= 10;
        }
        this.versionCheckTracker.putInt("runs_since_last_message", this.runsSinceLastMessage + 1);
        this.versionCheckTracker.put("lastversionfound", this.lastNewVersionFound);
        if (versionLines.length > 1 && versionLines[1].trim().length() != 0) {
            this.updateURL = versionLines[1];
        }
        this.setLogMessage(logMsg);
        this.setDialogMessage(dialogMsg);
    }

    public AppVersionChecker(String appName, String oldVer, String versionURL, String updateURL) {
        this(appName, oldVer, versionURL, updateURL, new String[]{"{appName} {oldVer} is out of date! Visit {updateURL} to download the latest release ({newVer})."}, new String[]{"{appName} {newVer} is out! Download the latest from {updateURL}"}, 5000);
    }

    public void checkVersionWithLogging() {
        if (!AppVersionChecker.isCurrentVersion(this.currentVersion, this.newVersion)) {
            for (String msg : this.logMsg) {
                System.out.println(msg);
            }
        }
    }

    public void setLogMessage(String[] logMsg) {
        this.logMsg = logMsg;
        for (int i = 0; i < this.logMsg.length; ++i) {
            this.logMsg[i] = this.replaceAllTags(this.logMsg[i]);
        }
    }

    public void setDialogMessage(String[] dialogMsg) {
        this.dialogMsg = dialogMsg;
        for (int i = 0; i < this.dialogMsg.length; ++i) {
            this.dialogMsg[i] = this.replaceAllTags(this.dialogMsg[i]);
        }
    }

    public String[] getLogMessage() {
        return this.logMsg;
    }

    public String[] getDialogMessage() {
        return this.dialogMsg;
    }

    public boolean isCurrentVersion() {
        return AppVersionChecker.isCurrentVersion(this.runsSinceLastMessage == 0 ? this.currentVersion : this.lastNewVersionFound, this.newVersion);
    }

    public static boolean isCurrentVersion(String currentVersion, String newVersion) {
        return new NaturalOrderComparator().compare(currentVersion, newVersion) >= 0;
    }

    private String replaceAllTags(String s) {
        return s.replace("{oldVer}", this.currentVersion).replace("{newVer}", this.newVersion).replace("{appName}", this.appName).replace("{updateURL}", this.updateURL);
    }

    public static String[] loadTextFromURL(URL url, String[] defaultValue, int timeoutMS) {
        ArrayList<String> arraylist = new ArrayList<String>();
        Scanner scanner = null;
        try {
            URLConnection uc = url.openConnection();
            uc.setReadTimeout(timeoutMS);
            uc.setConnectTimeout(timeoutMS);
            scanner = new Scanner(uc.getInputStream(), "UTF-8");
        }
        catch (Throwable e) {
            return defaultValue;
        }
        while (scanner.hasNextLine()) {
            arraylist.add(scanner.nextLine());
        }
        scanner.close();
        return arraylist.toArray(new String[arraylist.size()]);
    }
}

