/*
 * Decompiled with CFR 0.152.
 */
package com.rl.obf;

import com.rl.NameProvider;
import com.rl.obf.ClassTree;
import com.rl.obf.Fd;
import com.rl.obf.Md;
import com.rl.obf.NameListDown;
import com.rl.obf.NameListUp;
import com.rl.obf.PkCl;
import com.rl.obf.TreeItem;
import com.rl.obf.classfile.ClassFile;
import com.rl.obf.classfile.ClassFileException;
import com.rl.obf.classfile.FieldInfo;
import com.rl.obf.classfile.MethodInfo;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Cl
extends PkCl
implements NameListUp,
NameListDown {
    private Map<String, Md> mds = new HashMap<String, Md>();
    private Map<String, Md> mdsSpecial = new HashMap<String, Md>();
    private Map<String, Fd> fds = new HashMap<String, Fd>();
    private boolean isResolved = false;
    private boolean isScanned = false;
    private String superClass;
    private List<String> superInterfaces;
    private boolean isInnerClass;
    private List<NameListUp> nameListUps = new ArrayList<NameListUp>();
    private List<NameListDown> nameListDowns = new ArrayList<NameListDown>();
    private boolean isNoWarn = false;
    private List<String> warningList = new ArrayList<String>();
    public static int nameSpace = 0;
    private static Map<String, NameListUp> extNameListUpCache = new HashMap<String, NameListUp>();

    public Cl(TreeItem parent, boolean isInnerClass, String name, String superClass, List<String> superInterfaces, int access) {
        super(parent, name);
        if (NameProvider.oldHash) {
            this.mds = new Hashtable<String, Md>();
            this.mdsSpecial = new Hashtable<String, Md>();
            this.fds = new Hashtable<String, Fd>();
        }
        this.superClass = superClass;
        this.superInterfaces = superInterfaces;
        this.isInnerClass = isInnerClass;
        this.access = access;
        if (parent == null && "".equals(name)) {
            throw new RuntimeException("Internal error: class must have parent if name is empty");
        }
        if (parent instanceof Cl) {
            this.sep = "$";
        }
    }

    public boolean isInnerClass() {
        return this.isInnerClass;
    }

    public void setNoWarn() {
        this.isNoWarn = true;
    }

    public void setWarnings(ClassFile cf) {
        this.warningList = cf.listDangerMethods(this.warningList);
    }

    public boolean hasWarnings() {
        return !this.isNoWarn && this.warningList.size() > 0;
    }

    public void logWarnings(PrintWriter log) {
        if (this.hasWarnings()) {
            for (String warning : this.warningList) {
                log.println("# " + warning);
            }
        }
    }

    public Md getMethod(String name, String descriptor) {
        return this.mds.get(name + descriptor);
    }

    public Md getMethodSpecial(String name, String descriptor) {
        return this.mdsSpecial.get(name + descriptor);
    }

    public Fd getField(String name) {
        return this.fds.get(name);
    }

    public Collection<Md> getMethods() {
        return this.mds.values();
    }

    public Collection<Fd> getFields() {
        return this.fds.values();
    }

    public Cl getSuperCl() throws ClassFileException {
        if (this.superClass != null) {
            return this.classTree.getCl(this.superClass);
        }
        return null;
    }

    public List<Cl> getSuperInterfaces() throws ClassFileException {
        ArrayList<Cl> list = new ArrayList<Cl>();
        for (String si : this.superInterfaces) {
            Cl interfaceItem = this.classTree.getCl(si);
            if (interfaceItem == null) continue;
            list.add(interfaceItem);
        }
        return list;
    }

    protected boolean hasAsSuperInt(String queryName, boolean checkInterfaces) {
        block16: {
            try {
                Cl superClInt;
                if (this.superClass == null) {
                    return false;
                }
                if (this.superClass.equals(queryName)) {
                    return true;
                }
                if (checkInterfaces) {
                    for (String si : this.superInterfaces) {
                        if (!queryName.equals(si)) continue;
                        return true;
                    }
                }
                if ((superClInt = this.classTree.getCl(this.superClass)) != null) {
                    if (superClInt.hasAsSuperInt(queryName, checkInterfaces)) {
                        return true;
                    }
                } else {
                    Class<?> superClExt = null;
                    try {
                        superClExt = Class.forName(ClassFile.translate(this.superClass));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    if (superClExt != null && Cl.hasAsSuperExt(queryName, checkInterfaces, this.classTree, superClExt)) {
                        return true;
                    }
                }
                if (!checkInterfaces) break block16;
                for (String si : this.superInterfaces) {
                    Cl interClInt = this.classTree.getCl(si);
                    if (interClInt != null) {
                        if (!interClInt.hasAsSuperInt(queryName, checkInterfaces)) continue;
                        return true;
                    }
                    Class<?> interClExt = null;
                    try {
                        interClExt = Class.forName(ClassFile.translate(si));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    if (interClExt == null || !Cl.hasAsSuperExt(queryName, checkInterfaces, this.classTree, interClExt)) continue;
                    return true;
                }
            }
            catch (ClassFileException classFileException) {
                // empty catch block
            }
        }
        return false;
    }

    protected static boolean hasAsSuperExt(String queryName, boolean checkInterfaces, ClassTree classTree, Class<?> clExt) {
        try {
            Class<?> superClExt;
            Cl superClInt;
            if (clExt == null || clExt.getName().equals("java.lang.Object")) {
                return false;
            }
            String queryNameExt = ClassFile.translate(queryName);
            Class<?> superClass = clExt.getSuperclass();
            List<Class<?>> superInterfaces = Arrays.asList(clExt.getInterfaces());
            if (superClass != null && queryNameExt.equals(superClass.getName())) {
                return true;
            }
            if (checkInterfaces) {
                for (Class<?> si : superInterfaces) {
                    if (!queryNameExt.equals(si.getName())) continue;
                    return true;
                }
            }
            if (superClass != null && ((superClInt = classTree.getCl(ClassFile.backTranslate(superClass.getName()))) != null ? superClInt.hasAsSuperInt(queryName, checkInterfaces) : Cl.hasAsSuperExt(queryName, checkInterfaces, classTree, superClExt = superClass))) {
                return true;
            }
            if (checkInterfaces) {
                for (Class<?> si : superInterfaces) {
                    Class<?> interClExt;
                    Cl interClInt = classTree.getCl(ClassFile.backTranslate(si.getName()));
                    if (!(interClInt != null ? interClInt.hasAsSuperInt(queryName, checkInterfaces) : Cl.hasAsSuperExt(queryName, checkInterfaces, classTree, interClExt = si))) continue;
                    return true;
                }
            }
        }
        catch (ClassFileException classFileException) {
            // empty catch block
        }
        return false;
    }

    public boolean hasAsSuperOrInterface(String queryName) {
        return this.hasAsSuperInt(queryName, true);
    }

    public boolean hasAsSuper(String queryName) {
        return this.hasAsSuperInt(queryName, false);
    }

    @Override
    public Cl addClass(String name, String superName, List<String> interfaceNames, int access) {
        return this.addClass(true, name, superName, interfaceNames, access);
    }

    public Cl addClass(Cl cl) {
        this.cls.put(cl.getInName(), cl);
        return cl;
    }

    @Override
    public Cl addPlaceholderClass(String name) {
        return this.addPlaceholderClass(true, name);
    }

    public Md addMethod(ClassFile cf, MethodInfo md) throws ClassFileException {
        return this.addMethod(md.isSynthetic(), md.getName(), md.getDescriptor(), md.getAccessFlags());
    }

    public Md addMethod(boolean isSynthetic, String name, String descriptor, int accessFlags) throws ClassFileException {
        Md md;
        if (name.charAt(0) == '<') {
            md = this.getMethodSpecial(name, descriptor);
            if (md == null) {
                md = new Md(this, isSynthetic, name, descriptor, accessFlags);
                this.mdsSpecial.put(name + descriptor, md);
            }
        } else {
            md = this.getMethod(name, descriptor);
            if (md == null) {
                md = new Md(this, isSynthetic, name, descriptor, accessFlags);
                this.mds.put(name + descriptor, md);
            }
        }
        return md;
    }

    public Fd addField(ClassFile cf, FieldInfo fd) throws ClassFileException {
        return this.addField(fd.isSynthetic(), fd.getName(), fd.getDescriptor(), fd.getAccessFlags());
    }

    public Fd addField(boolean isSynthetic, String name, String descriptor, int access) throws ClassFileException {
        Fd fd = this.getField(name);
        if (fd == null) {
            fd = new Fd(this, isSynthetic, name, descriptor, access);
            this.fds.put(name, fd);
        }
        return fd;
    }

    public void resetResolve() {
        this.isScanned = false;
        this.isResolved = false;
        this.nameListDowns.clear();
    }

    public void setupNameListDowns() throws ClassFileException {
        if (this.superClass == null) {
            return;
        }
        Cl superClassItem = this.classTree.getCl(this.superClass);
        if (superClassItem != null) {
            superClassItem.nameListDowns.add(this);
        }
        for (String si : this.superInterfaces) {
            Cl interfaceItem = this.classTree.getCl(si);
            if (interfaceItem == null) continue;
            interfaceItem.nameListDowns.add(this);
        }
    }

    public void resolveOptimally() throws ClassFileException {
        if (!this.isResolved) {
            ArrayList<String> methods = new ArrayList<String>();
            ArrayList<String> fields = new ArrayList<String>();
            this.scanNameSpaceExcept(null, methods, fields);
            this.resolveNameSpaceExcept(null);
            ++nameSpace;
        }
    }

    private void scanNameSpaceExcept(Cl ignoreCl, List<String> methods, List<String> fields) throws ClassFileException {
        if (this.superClass == null) {
            return;
        }
        if (!this.isScanned) {
            Cl superCl = this.classTree.getCl(this.superClass);
            if (superCl != null) {
                if (superCl != ignoreCl) {
                    superCl.scanNameSpaceExcept(this, methods, fields);
                }
            } else {
                Cl.scanExtSupers(this.superClass, methods, fields);
            }
            for (String si : this.superInterfaces) {
                Cl interfaceItem = this.classTree.getCl(si);
                if (interfaceItem == null || interfaceItem == ignoreCl) continue;
                interfaceItem.scanNameSpaceExcept(this, methods, fields);
            }
            if (!this.isScanned) {
                this.scanThis(methods, fields);
                this.isScanned = true;
            }
            for (NameListDown nameListDown : this.nameListDowns) {
                Cl cl = (Cl)nameListDown;
                if (cl == ignoreCl) continue;
                cl.scanNameSpaceExcept(this, methods, fields);
            }
        }
    }

    private static void scanExtSupers(String name, List<String> methods, List<String> fields) {
        Class<?> extClass = null;
        try {
            extClass = Class.forName(ClassFile.translate(name));
        }
        catch (ClassNotFoundException e) {
            return;
        }
        List<Method> allPubMethods = Arrays.asList(extClass.getMethods());
        for (Method method : allPubMethods) {
            String string = method.getName();
            if (methods.contains(string)) continue;
            methods.add(string);
        }
        List<Field> allPubFields = Arrays.asList(extClass.getFields());
        for (Field field : allPubFields) {
            String fieldName = field.getName();
            if (fields.contains(fieldName)) continue;
            fields.add(fieldName);
        }
        while (extClass != null) {
            List<Method> list = Arrays.asList(extClass.getDeclaredMethods());
            for (Method md : list) {
                String methodName;
                if (Modifier.isPublic(md.getModifiers()) || methods.contains(methodName = md.getName())) continue;
                methods.add(methodName);
            }
            List<Field> list2 = Arrays.asList(extClass.getDeclaredFields());
            for (Field fd : list2) {
                String fieldName;
                if (Modifier.isPublic(fd.getModifiers()) || fields.contains(fieldName = fd.getName())) continue;
                fields.add(fieldName);
            }
            extClass = extClass.getSuperclass();
        }
    }

    private void scanThis(List<String> methods, List<String> fields) {
        String name;
        for (Md md : this.mds.values()) {
            if (!md.isFixed() || methods.contains(name = md.getOutName())) continue;
            methods.add(name);
        }
        for (Fd fd : this.fds.values()) {
            if (!fd.isFixed() || fields.contains(name = fd.getOutName())) continue;
            fields.add(name);
        }
    }

    private void resolveNameSpaceExcept(Cl ignoreCl) throws ClassFileException {
        if (this.superClass == null) {
            return;
        }
        if (!this.isResolved) {
            Cl superCl = this.classTree.getCl(this.superClass);
            if (superCl != null && superCl != ignoreCl) {
                superCl.resolveNameSpaceExcept(this);
            }
            for (String si : this.superInterfaces) {
                Cl interfaceItem = this.classTree.getCl(si);
                if (interfaceItem == null || interfaceItem == ignoreCl) continue;
                interfaceItem.resolveNameSpaceExcept(this);
            }
            if (!this.isResolved) {
                this.resolveThis();
                this.isResolved = true;
            }
            for (NameListDown nameListDown : this.nameListDowns) {
                Cl cl = (Cl)nameListDown;
                if (cl == ignoreCl) continue;
                cl.resolveNameSpaceExcept(this);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void resolveThis() throws ClassFileException {
        String theInName;
        if (this.superClass == null) {
            return;
        }
        Cl superClassItem = this.classTree.getCl(this.superClass);
        if (superClassItem != null) {
            this.nameListUps.add(superClassItem);
        } else {
            this.nameListUps.add(this.getExtNameListUp(this.superClass));
        }
        for (String si : this.superInterfaces) {
            Cl interfaceItem = this.classTree.getCl(si);
            if (interfaceItem != null) {
                this.nameListUps.add(interfaceItem);
                continue;
            }
            this.nameListUps.add(this.getExtNameListUp(si));
        }
        block1: for (Md md : this.mds.values()) {
            theInName = md.getInName();
            String theInDesc = md.getDescriptor();
            String fullInName = md.getFullInName();
            if (!md.isFixed()) {
                String string;
                void var8_17;
                boolean checkDown = true;
                if (NameProvider.fixShadowed) {
                    if (Modifier.isPrivate(md.access) || Modifier.isStatic(md.access) || Modifier.isFinal(md.access)) {
                        checkDown = false;
                    }
                } else if (Modifier.isPrivate(md.access)) {
                    checkDown = false;
                }
                if (checkDown) {
                    for (NameListDown nameListDown : this.nameListDowns) {
                        String theOutName2 = nameListDown.getMethodObfNameDown(this, theInName, theInDesc);
                        if (theOutName2 == null) continue;
                        md.setOutName(theOutName2);
                        if (theOutName2.equals(theInName)) {
                            NameProvider.verboseLog("# Method " + fullInName + " unchanged from derived class");
                        } else {
                            NameProvider.verboseLog("# Method " + fullInName + " renamed to " + theOutName2 + " from derived class");
                        }
                        if (!NameProvider.fullMap) continue block1;
                        md.setOutput();
                        continue block1;
                    }
                }
                boolean bl = true;
                if (NameProvider.fixShadowed) {
                    if (Modifier.isPrivate(md.access) || Modifier.isStatic(md.access)) {
                        boolean bl2 = false;
                    }
                } else if (Modifier.isPrivate(md.access)) {
                    boolean bl3 = false;
                }
                if (var8_17 != false) {
                    for (NameListUp nl3 : this.nameListUps) {
                        String theOutName3 = nl3.getMethodOutNameUp(theInName, theInDesc);
                        if (theOutName3 == null) continue;
                        md.setOutName(theOutName3);
                        md.setIsOverride();
                        if (theOutName3.equals(theInName)) {
                            NameProvider.verboseLog("# Method " + fullInName + " unchanged from super class");
                        } else {
                            NameProvider.verboseLog("# Method " + fullInName + " renamed to " + theOutName3 + " from super class");
                        }
                        if (!NameProvider.fullMap) continue block1;
                        md.setOutput();
                        continue block1;
                    }
                }
                if ((string = NameProvider.getNewMethodName(md)) != null) {
                    md.setOutName(string);
                    md.setFromScriptMap();
                    if (string.equals(theInName)) {
                        NameProvider.verboseLog("# Method " + fullInName + " unchanged from name maker");
                        continue;
                    }
                    NameProvider.verboseLog("# Method " + fullInName + " renamed to " + string + " from name maker");
                    continue;
                }
                NameProvider.verboseLog("# Method " + fullInName + " null from name maker");
                continue;
            }
            if (md.isFromScriptMap()) {
                String theOutName4 = md.getOutName();
                if (theOutName4.equals(theInName)) {
                    NameProvider.verboseLog("# Method " + fullInName + " unchanged from ScriptMap");
                    continue;
                }
                NameProvider.verboseLog("# Method " + fullInName + " renamed to " + theOutName4 + " from ScriptMap");
                continue;
            }
            if (md.isFromScript()) {
                NameProvider.verboseLog("# Method " + fullInName + " fixed from Script");
                continue;
            }
            NameProvider.verboseLog("# Method " + fullInName + " fixed");
        }
        block4: for (Fd fd : this.fds.values()) {
            theInName = fd.getInName();
            String fullInName = fd.getFullInName();
            if (!fd.isFixed()) {
                String string;
                boolean checkDown = true;
                if (NameProvider.fixShadowed) {
                    if (Modifier.isPrivate(fd.access) || Modifier.isStatic(fd.access) || Modifier.isFinal(fd.access)) {
                        checkDown = false;
                    }
                } else if (Modifier.isPrivate(fd.access)) {
                    checkDown = false;
                }
                if (checkDown) {
                    for (NameListDown nameListDown : this.nameListDowns) {
                        String string2 = nameListDown.getFieldObfNameDown(this, theInName);
                        if (string2 == null) continue;
                        fd.setOutName(string2);
                        if (string2.equals(theInName)) {
                            NameProvider.verboseLog("# Field " + fullInName + " unchanged from derived class");
                        } else {
                            NameProvider.verboseLog("# Field " + fullInName + " renamed to " + string2 + " from derived class");
                        }
                        if (!NameProvider.fullMap) continue block4;
                        fd.setOutput();
                        continue block4;
                    }
                }
                boolean checkUp = true;
                if (NameProvider.fixShadowed) {
                    if (Modifier.isPrivate(fd.access) || Modifier.isStatic(fd.access) || Modifier.isFinal(fd.access)) {
                        checkDown = false;
                    }
                } else if (Modifier.isPrivate(fd.access)) {
                    checkDown = false;
                }
                if (checkUp) {
                    for (NameListUp nameListUp : this.nameListUps) {
                        String theOutName = nameListUp.getFieldOutNameUp(theInName);
                        if (theOutName == null) continue;
                        fd.setOutName(theOutName);
                        fd.setIsOverride();
                        if (theOutName.equals(theInName)) {
                            NameProvider.verboseLog("# Field " + fullInName + " unchanged from super class");
                        } else {
                            NameProvider.verboseLog("# Field " + fullInName + " renamed to " + theOutName + " from super class");
                        }
                        if (!NameProvider.fullMap) continue block4;
                        fd.setOutput();
                        continue block4;
                    }
                }
                if ((string = NameProvider.getNewFieldName(fd)) != null) {
                    fd.setOutName(string);
                    fd.setFromScriptMap();
                    if (string.equals(theInName)) {
                        NameProvider.verboseLog("# Field " + fullInName + " unchanged from name maker");
                        continue;
                    }
                    NameProvider.verboseLog("# Field " + fullInName + " renamed to " + string + " from name maker");
                    continue;
                }
                NameProvider.verboseLog("# Field " + fullInName + " null from name maker");
                continue;
            }
            if (fd.isFromScriptMap()) {
                String theOutName6 = fd.getOutName();
                if (theOutName6.equals(theInName)) {
                    NameProvider.verboseLog("# Field " + fullInName + " unchanged from ScriptMap");
                    continue;
                }
                NameProvider.verboseLog("# Field " + fullInName + " renamed to " + theOutName6 + " from ScriptMap");
                continue;
            }
            if (fd.isFromScript()) {
                NameProvider.verboseLog("# Field " + fullInName + " fixed from Script");
                continue;
            }
            NameProvider.verboseLog("# Field " + fullInName + " fixed");
        }
    }

    @Override
    public String getMethodOutNameUp(String name, String descriptor) throws ClassFileException {
        for (NameListUp nl : this.nameListUps) {
            String superOutName = nl.getMethodOutNameUp(name, descriptor);
            if (superOutName == null) continue;
            return superOutName;
        }
        Md md = this.getMethod(name, descriptor);
        if (md != null && (NameProvider.fixShadowed ? !Modifier.isPrivate(md.access) && !Modifier.isStatic(md.access) && !Modifier.isFinal(md.access) : !Modifier.isPrivate(md.access))) {
            return md.getOutName();
        }
        return null;
    }

    @Override
    public String getMethodObfNameUp(String name, String descriptor) throws ClassFileException {
        for (NameListUp nl : this.nameListUps) {
            String superObfName = nl.getMethodObfNameUp(name, descriptor);
            if (superObfName == null) continue;
            return superObfName;
        }
        Md md = this.getMethod(name, descriptor);
        if (md != null && (NameProvider.fixShadowed ? !Modifier.isPrivate(md.access) && !Modifier.isStatic(md.access) && !Modifier.isFinal(md.access) : !Modifier.isPrivate(md.access))) {
            return md.getObfName();
        }
        return null;
    }

    @Override
    public String getFieldOutNameUp(String name) throws ClassFileException {
        for (NameListUp nl : this.nameListUps) {
            String superOutName = nl.getFieldOutNameUp(name);
            if (superOutName == null) continue;
            return superOutName;
        }
        Fd fd = this.getField(name);
        if (fd != null && (NameProvider.fixShadowed ? !Modifier.isPrivate(fd.access) && !Modifier.isStatic(fd.access) && !Modifier.isFinal(fd.access) : !Modifier.isPrivate(fd.access))) {
            return fd.getOutName();
        }
        return null;
    }

    @Override
    public String getFieldObfNameUp(String name) throws ClassFileException {
        for (NameListUp nl : this.nameListUps) {
            String superObfName = nl.getFieldObfNameUp(name);
            if (superObfName == null) continue;
            return superObfName;
        }
        Fd fd = this.getField(name);
        if (fd != null && (NameProvider.fixShadowed ? !Modifier.isPrivate(fd.access) && !Modifier.isStatic(fd.access) && !Modifier.isFinal(fd.access) : !Modifier.isPrivate(fd.access))) {
            return fd.getObfName();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getMethodObfNameDown(Cl caller, String name, String descriptor) throws ClassFileException {
        Md md = this.getMethod(name, descriptor);
        if (md != null && md.isFixed()) {
            return md.getOutName();
        }
        String theObfName = null;
        if (this.superClass != null) {
            Cl superClassItem = this.classTree.getCl(this.superClass);
            if (superClassItem != caller) {
                void var7_9;
                if (superClassItem != null) {
                    Cl cl = superClassItem;
                } else {
                    NameListUp nameListUp = this.getExtNameListUp(this.superClass);
                }
                theObfName = var7_9.getMethodObfNameUp(name, descriptor);
                if (theObfName != null) {
                    return theObfName;
                }
            }
            for (String si : this.superInterfaces) {
                NameListUp nl;
                Cl interfaceItem = this.classTree.getCl(si);
                if (interfaceItem == caller) continue;
                if (interfaceItem != null) {
                    Cl nl2 = interfaceItem;
                } else {
                    nl = this.getExtNameListUp(si);
                }
                if ((theObfName = nl.getMethodObfNameUp(name, descriptor)) == null) continue;
                return theObfName;
            }
        }
        for (NameListDown nameListDown : this.nameListDowns) {
            theObfName = nameListDown.getMethodObfNameDown(this, name, descriptor);
            if (theObfName == null) continue;
            return theObfName;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getFieldObfNameDown(Cl caller, String name) throws ClassFileException {
        Fd fd = this.getField(name);
        if (fd != null && fd.isFixed()) {
            return fd.getOutName();
        }
        String theObfName = null;
        if (this.superClass != null) {
            Cl superClassItem = this.classTree.getCl(this.superClass);
            if (superClassItem != caller) {
                void var6_8;
                if (superClassItem != null) {
                    Cl cl = superClassItem;
                } else {
                    NameListUp nameListUp = this.getExtNameListUp(this.superClass);
                }
                theObfName = var6_8.getFieldObfNameUp(name);
                if (theObfName != null) {
                    return theObfName;
                }
            }
            for (String si : this.superInterfaces) {
                NameListUp nl;
                Cl interfaceItem = this.classTree.getCl(si);
                if (interfaceItem == caller) continue;
                if (interfaceItem != null) {
                    Cl nl2 = interfaceItem;
                } else {
                    nl = this.getExtNameListUp(si);
                }
                if ((theObfName = nl.getFieldObfNameUp(name)) == null) continue;
                return theObfName;
            }
        }
        for (NameListDown nameListDown : this.nameListDowns) {
            theObfName = nameListDown.getFieldObfNameDown(this, name);
            if (theObfName == null) continue;
            return theObfName;
        }
        return null;
    }

    private NameListUp getExtNameListUp(String name) throws ClassFileException {
        NameListUp nl = extNameListUpCache.get(name);
        if (nl == null) {
            nl = new ExtNameListUp(name);
            extNameListUpCache.put(name, nl);
        }
        return nl;
    }

    @Override
    public String getFullOutName() {
        String repackageName = this.getRepackageName();
        if (repackageName != null) {
            return repackageName;
        }
        return super.getFullOutName();
    }

    public Iterator<Cl> getDownClasses() {
        ArrayList<Cl> clsList = new ArrayList<Cl>();
        for (NameListDown nameListDown : this.nameListDowns) {
            Cl cl = (Cl)nameListDown;
            clsList.add(cl);
        }
        return clsList.iterator();
    }

    class ExtNameListUp
    implements NameListUp {
        private Class<?> extClass;
        private List<Method> methods = null;

        public ExtNameListUp(String name) throws ClassFileException {
            try {
                this.extClass = Class.forName(ClassFile.translate(name));
            }
            catch (ClassNotFoundException e) {
                throw new ClassFileException("ClassNotFound " + name);
            }
        }

        @Override
        public String getMethodObfNameUp(String name, String descriptor) throws ClassFileException {
            return this.getMethodOutNameUp(name, descriptor);
        }

        @Override
        public String getMethodOutNameUp(String name, String descriptor) throws ClassFileException {
            if (this.methods == null) {
                List<Method> allMethods = this.getAllDeclaredMethods(this.extClass);
                this.methods = new ArrayList<Method>();
                for (Method md : allMethods) {
                    int modifiers = md.getModifiers();
                    if (NameProvider.fixShadowed) {
                        if (Modifier.isPrivate(modifiers) || Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) continue;
                        this.methods.add(md);
                        continue;
                    }
                    if (Modifier.isPrivate(modifiers)) continue;
                    this.methods.add(md);
                }
            }
            block1: for (Method md : this.methods) {
                if (!name.equals(md.getName())) continue;
                List<String> paramAndReturnNames = ClassFile.parseMethodDescriptor(descriptor);
                List<String> paramNames = paramAndReturnNames.subList(0, paramAndReturnNames.size() - 1);
                String returnName = paramAndReturnNames.get(paramAndReturnNames.size() - 1);
                List<Class<?>> paramTypes = Arrays.asList(md.getParameterTypes());
                Class<?> returnType = md.getReturnType();
                if (paramNames.size() != paramTypes.size()) continue;
                for (int j = 0; j < paramNames.size(); ++j) {
                    if (!paramNames.get(j).equals(paramTypes.get(j).getName())) continue block1;
                }
                if (!returnName.equals(returnType.getName())) continue;
                return name;
            }
            return null;
        }

        @Override
        public String getFieldObfNameUp(String name) {
            return this.getFieldOutNameUp(name);
        }

        @Override
        public String getFieldOutNameUp(String name) {
            Field field = this.getAllDeclaredField(this.extClass, name);
            if (field != null) {
                int modifiers = field.getModifiers();
                if (NameProvider.fixShadowed ? !Modifier.isPrivate(modifiers) && !Modifier.isStatic(modifiers) && !Modifier.isFinal(modifiers) : !Modifier.isPrivate(modifiers)) {
                    return name;
                }
            }
            return null;
        }

        private List<Method> getAllDeclaredMethods(Class<?> theClass) {
            ArrayList<Method> ma = new ArrayList<Method>();
            ma.addAll(Arrays.asList(theClass.getMethods()));
            while (theClass != null) {
                ma.addAll(Arrays.asList(theClass.getDeclaredMethods()));
                theClass = theClass.getSuperclass();
            }
            return ma;
        }

        private Field getAllDeclaredField(Class<?> theClass, String name) {
            Class<?> origClass = theClass;
            while (theClass != null) {
                Field field = null;
                try {
                    field = theClass.getDeclaredField(name);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
                if (field != null) {
                    return field;
                }
                theClass = theClass.getSuperclass();
            }
            try {
                return origClass.getField(name);
            }
            catch (NoSuchFieldException e) {
                return null;
            }
        }
    }
}

