/*
 * Decompiled with CFR 0.152.
 */
package com.rl.obf;

import com.rl.NameProvider;
import com.rl.obf.Cl;
import com.rl.obf.Pk;
import com.rl.obf.PlaceholderCl;
import com.rl.obf.TreeItem;
import com.rl.obf.classfile.ClassFileException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public abstract class PkCl
extends TreeItem {
    protected Map<String, Cl> cls = new HashMap<String, Cl>();
    private String repackageName = null;

    public PkCl(TreeItem parent, String name) {
        super(parent, name);
        if (NameProvider.oldHash) {
            this.cls = new Hashtable<String, Cl>();
        }
    }

    public Cl getClass(String name) {
        return this.cls.get(name);
    }

    public Collection<Cl> getClasses() {
        return this.cls.values();
    }

    public abstract Cl addClass(String var1, String var2, List<String> var3, int var4);

    public Cl addClass(boolean isInnerClass, String name, String superName, List<String> interfaceNames, int access) {
        Cl cl = this.getClass(name);
        PlaceholderCl plClassItem = null;
        if (cl instanceof PlaceholderCl) {
            plClassItem = (PlaceholderCl)cl;
            this.cls.remove(name);
            cl = null;
        }
        if (cl == null) {
            cl = new Cl(this, isInnerClass, name, superName, interfaceNames, access);
            this.cls.put(name, cl);
        }
        if (plClassItem != null) {
            for (Cl innerCl : plClassItem.getClasses()) {
                innerCl.setParent(cl);
                cl.addClass(innerCl);
            }
        }
        return cl;
    }

    public abstract Cl addPlaceholderClass(String var1);

    public Cl addPlaceholderClass(boolean isInnerClass, String name) {
        Cl cl = this.getClass(name);
        if (cl == null) {
            cl = new PlaceholderCl(this, isInnerClass, name);
            this.cls.put(name, cl);
        }
        return cl;
    }

    public void generateNames() throws ClassFileException {
        PkCl.generateNames(this.cls);
    }

    public void setRepackageName(String repackageName) {
        this.repackageName = repackageName.equals(".") ? "" : repackageName;
    }

    public String getRepackageName() {
        return this.repackageName;
    }

    public String getRepackageName(boolean output) {
        String s = this.repackageName;
        if (output && s.equals("")) {
            s = ".";
        }
        return s;
    }

    protected static void generateNames(Map<String, ? extends TreeItem> hash) {
        for (TreeItem treeItem : hash.values()) {
            String fullInName = treeItem.getFullInName(true);
            String thisType = "Misc";
            if (treeItem instanceof Pk) {
                thisType = "Package";
            }
            if (treeItem instanceof Cl) {
                thisType = "Class";
            }
            if (NameProvider.currentMode != 0 || !treeItem.isFixed()) {
                String theOutName = NameProvider.getNewTreeItemName(treeItem);
                if (theOutName != null) {
                    treeItem.setOutName(theOutName);
                    treeItem.setFromScriptMap();
                    String fullOutName = treeItem.getFullOutName(true);
                    if (fullOutName.equals(fullInName)) {
                        NameProvider.verboseLog("# " + thisType + " " + fullInName + " unchanged from name maker");
                        continue;
                    }
                    NameProvider.verboseLog("# " + thisType + " " + fullInName + " renamed to " + fullOutName + " from name maker");
                    continue;
                }
                NameProvider.verboseLog("# " + thisType + " " + fullInName + " null from name maker");
                continue;
            }
            if (!treeItem.isFixed()) continue;
            if (treeItem.isFromScriptMap()) {
                String fullOutName = treeItem.getFullOutName(true);
                if (fullOutName.equals(fullInName)) {
                    NameProvider.verboseLog("# " + thisType + " " + fullInName + " unchanged from ScriptMap");
                    continue;
                }
                NameProvider.verboseLog("# " + thisType + " " + fullInName + " renamed to " + fullOutName + " from ScriptMap");
                continue;
            }
            if (treeItem.isFromScript()) {
                NameProvider.verboseLog("# " + thisType + " " + fullInName + " fixed from Script");
                continue;
            }
            NameProvider.verboseLog("# " + thisType + " " + fullInName + " fixed");
        }
    }
}

