/*
 * Decompiled with CFR 0.152.
 */
package com.rl.obf;

import com.rl.obf.ClassTree;
import com.rl.obf.PatternList;
import java.util.ArrayList;

public class TreeItem {
    protected boolean isSynthetic;
    protected int access;
    protected ClassTree classTree = null;
    protected TreeItem parent = null;
    protected String sep = "/";
    private String inName = null;
    private String outName = null;
    private boolean isFixed = false;
    private boolean isFromScript = false;
    private boolean isFromScriptMap = false;
    protected boolean isOutput = false;

    public static boolean isMatch(String pattern, String string) {
        if (pattern == null || string == null) {
            return false;
        }
        if (pattern.indexOf(42) == -1) {
            return pattern.equals(string);
        }
        int pos = -1;
        if (pattern.charAt(0) != '*') {
            pos = pattern.indexOf(42);
            String head = pattern.substring(0, pos);
            if (string.length() < head.length()) {
                return false;
            }
            if (!string.substring(0, head.length()).equals(head)) {
                return false;
            }
            pattern = pattern.substring(pos);
            string = string.substring(pos);
        }
        if (pattern.charAt(pattern.length() - 1) != '*') {
            pos = pattern.lastIndexOf(42);
            String tail = pattern.substring(pos + 1);
            if (string.length() < tail.length()) {
                return false;
            }
            if (!string.substring(string.length() - tail.length()).equals(tail)) {
                return false;
            }
            pattern = pattern.substring(0, pos + 1);
            string = string.substring(0, string.length() - tail.length());
        }
        ArrayList<String> section = new ArrayList<String>();
        pos = pattern.indexOf(42);
        int rpos = -1;
        while ((rpos = pattern.indexOf(42, pos + 1)) != -1) {
            if (rpos != pos + 1) {
                section.add(pattern.substring(pos + 1, rpos));
            }
            pos = rpos;
        }
        for (String chunk : section) {
            pos = string.indexOf(chunk);
            if (pos == -1) {
                return false;
            }
            string = string.substring(pos + chunk.length());
        }
        return true;
    }

    public static boolean isGMatch(String pattern, String string) {
        PatternList pl = PatternList.create(pattern);
        PatternList sl = PatternList.create(string);
        if (!pl.scExists()) {
            if (pl.length() != sl.length()) {
                return false;
            }
            for (int i = 0; i < pl.length(); ++i) {
                if (TreeItem.isMatch(pl.getSub(i), sl.getSub(i))) continue;
                return false;
            }
        } else {
            int i;
            if (pl.length() > sl.length()) {
                return false;
            }
            for (i = 0; i < pl.scIndex(); ++i) {
                if (TreeItem.isMatch(pl.getSub(i), sl.getSub(i))) continue;
                return false;
            }
            for (i = pl.scIndex() + 1; i < pl.length(); ++i) {
                int j = i + sl.length() - pl.length();
                if (TreeItem.isMatch(pl.getSub(i), sl.getSub(j))) continue;
                return false;
            }
            int j = pl.scIndex() + sl.length() - pl.length();
            if (!TreeItem.isMatch(pl.getSub(pl.scIndex()), sl.getSub(pl.scIndex(), j))) {
                return false;
            }
        }
        return true;
    }

    public TreeItem(TreeItem parent, String name) {
        this.parent = parent;
        this.inName = name;
        if (parent != null) {
            this.classTree = parent.classTree;
        }
    }

    public int getModifiers() {
        return this.access;
    }

    public boolean modifiersMatchMask(int mask, int setting) {
        return (this.getModifiers() & mask) == (setting & mask);
    }

    public String getInName() {
        return this.inName;
    }

    public void setOutName(String outName) {
        this.outName = outName;
        this.isFixed = true;
    }

    public String getOutName() {
        if (this.outName != null) {
            return this.outName;
        }
        return this.inName;
    }

    public String getOutName(boolean output) {
        String s = this.getOutName();
        if (output && s.equals("")) {
            s = ".";
        }
        return s;
    }

    public String getObfName() {
        return this.outName;
    }

    public void setFromScript() {
        this.isFromScript = true;
    }

    public void clearFromScript() {
        if (this.isFromScript) {
            this.isFixed = false;
            this.isFromScript = false;
        }
    }

    public void setFromScriptMap() {
        this.isFromScriptMap = true;
    }

    public void setOutput() {
        this.isOutput = true;
    }

    public boolean isFixed() {
        return this.isFixed;
    }

    public boolean isFromScript() {
        return this.isFromScript;
    }

    public boolean isFromScriptMap() {
        return this.isFromScriptMap;
    }

    public boolean isSynthetic() {
        return this.isSynthetic;
    }

    public boolean isOutput() {
        return this.isOutput;
    }

    public void setParent(TreeItem parent) {
        this.parent = parent;
    }

    public TreeItem getParent() {
        return this.parent;
    }

    public String getFullInName() {
        if (this.parent == null) {
            return this.getInName();
        }
        return TreeItem.joinName(this.parent.getFullInName(), this.sep, this.getInName());
    }

    public String getFullInName(boolean output) {
        String s = this.getFullInName();
        if (output && s.equals("")) {
            s = ".";
        }
        return s;
    }

    public String getFullOutName() {
        if (this.parent == null) {
            return this.getOutName();
        }
        return TreeItem.joinName(this.parent.getFullOutName(), this.sep, this.getOutName());
    }

    public String getFullOutName(boolean output) {
        String s = this.getFullOutName();
        if (output && s.equals("")) {
            s = ".";
        }
        return s;
    }

    public static String joinName(String parentName, String sep, String name) {
        if (parentName.equals("")) {
            return name;
        }
        return parentName + sep + name;
    }

    public boolean isOldStyleMatch(String pattern) {
        return TreeItem.isMatch(pattern, this.getFullInName());
    }

    public boolean isWildcardMatch(String pattern) {
        return TreeItem.isGMatch(pattern, this.getFullInName());
    }
}

