/*
 * Decompiled with CFR 0.152.
 */
package com.rl.obf.classfile;

import com.rl.obf.classfile.AttrInfo;
import com.rl.obf.classfile.ClassConstants;
import com.rl.obf.classfile.ClassFile;
import com.rl.obf.classfile.ClassFileException;
import com.rl.obf.classfile.ConstantPool;
import com.rl.obf.classfile.FieldInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class ClassItemInfo
implements ClassConstants {
    private int u2accessFlags;
    private int u2nameIndex;
    private int u2descriptorIndex;
    protected List<AttrInfo> attributes;
    protected ClassFile cf;
    private boolean isSynthetic = false;

    protected ClassItemInfo(ClassFile cf) {
        this.cf = cf;
    }

    public boolean isSynthetic() {
        return this.isSynthetic;
    }

    protected int getNameIndex() {
        return this.u2nameIndex;
    }

    protected void setNameIndex(int index) {
        this.u2nameIndex = index;
    }

    protected int getDescriptorIndex() {
        return this.u2descriptorIndex;
    }

    protected void setDescriptorIndex(int index) {
        this.u2descriptorIndex = index;
    }

    public String getName() throws ClassFileException {
        return this.cf.getUtf8(this.u2nameIndex);
    }

    public String getDescriptor() throws ClassFileException {
        return this.cf.getUtf8(this.u2descriptorIndex);
    }

    public int getAccessFlags() {
        return this.u2accessFlags;
    }

    protected void trimAttrsExcept(List<String> keepAttrs) {
        ArrayList<AttrInfo> delAttrs = new ArrayList<AttrInfo>();
        for (AttrInfo at : this.attributes) {
            if (keepAttrs.contains(at.getAttrName())) {
                at.trimAttrsExcept(keepAttrs);
                continue;
            }
            delAttrs.add(at);
        }
        this.attributes.removeAll(delAttrs);
    }

    protected void markUtf8Refs(ConstantPool pool) throws ClassFileException {
        pool.incRefCount(this.u2nameIndex);
        pool.incRefCount(this.u2descriptorIndex);
        for (AttrInfo at : this.attributes) {
            at.markUtf8Refs(pool);
        }
    }

    protected void read(DataInput din) throws IOException, ClassFileException {
        this.u2accessFlags = din.readUnsignedShort();
        this.u2nameIndex = din.readUnsignedShort();
        this.u2descriptorIndex = din.readUnsignedShort();
        int u2attributesCount = din.readUnsignedShort();
        this.attributes = new ArrayList<AttrInfo>(u2attributesCount);
        for (int i = 0; i < u2attributesCount; ++i) {
            AttrInfo at = AttrInfo.create(din, this.cf, this instanceof FieldInfo ? ClassConstants.AttrSource.FIELD : ClassConstants.AttrSource.METHOD);
            this.attributes.add(at);
            if (!at.getAttrName().equals("Synthetic")) continue;
            this.isSynthetic = true;
        }
    }

    public void write(DataOutput dout) throws IOException, ClassFileException {
        if (dout == null) {
            throw new IOException("No output stream was provided.");
        }
        dout.writeShort(this.u2accessFlags);
        dout.writeShort(this.u2nameIndex);
        dout.writeShort(this.u2descriptorIndex);
        dout.writeShort(this.attributes.size());
        for (AttrInfo at : this.attributes) {
            at.write(dout);
        }
    }
}

