/*
 * Decompiled with CFR 0.152.
 */
package com.rl.obf.classfile;

import com.rl.obf.classfile.ClassFile;
import com.rl.obf.classfile.ClassFileException;
import com.rl.obf.classfile.ConstantPool;
import com.rl.obf.classfile.CpInfo;
import com.rl.obf.classfile.NameAndTypeCpInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class InvokeDynamicCpInfo
extends CpInfo {
    private int u2bootstrapMethodAttrIndex;
    private int u2nameAndTypeIndex;

    public InvokeDynamicCpInfo() {
        super(18);
    }

    protected int getBootstrapMethodAttrIndex() {
        return this.u2bootstrapMethodAttrIndex;
    }

    protected int getNameAndTypeIndex() {
        return this.u2nameAndTypeIndex;
    }

    protected void setNameAndTypeIndex(int index) {
        this.u2nameAndTypeIndex = index;
    }

    public String getName(ClassFile cf) throws ClassFileException {
        NameAndTypeCpInfo ntCpInfo = (NameAndTypeCpInfo)cf.getCpEntry(this.u2nameAndTypeIndex);
        return cf.getUtf8(ntCpInfo.getNameIndex());
    }

    public String getDescriptor(ClassFile cf) throws ClassFileException {
        NameAndTypeCpInfo ntCpInfo = (NameAndTypeCpInfo)cf.getCpEntry(this.u2nameAndTypeIndex);
        return cf.getUtf8(ntCpInfo.getDescriptorIndex());
    }

    @Override
    protected void markNTRefs(ConstantPool pool) throws ClassFileException {
        pool.incRefCount(this.u2nameAndTypeIndex);
    }

    @Override
    protected void readInfo(DataInput din) throws IOException, ClassFileException {
        this.u2bootstrapMethodAttrIndex = din.readUnsignedShort();
        this.u2nameAndTypeIndex = din.readUnsignedShort();
    }

    @Override
    protected void writeInfo(DataOutput dout) throws IOException, ClassFileException {
        dout.writeShort(this.u2bootstrapMethodAttrIndex);
        dout.writeShort(this.u2nameAndTypeIndex);
    }
}

