/*
 * Decompiled with CFR 0.152.
 */
package com.rl.obf.classfile;

import com.rl.obf.classfile.ClassFile;
import com.rl.obf.classfile.ClassFileException;
import com.rl.obf.classfile.ConstantPool;
import com.rl.obf.classfile.NameMapper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LocalVariableInfo {
    private int u2startpc;
    private int u2length;
    private int u2nameIndex;
    private int u2descriptorIndex;
    private int u2index;

    public static LocalVariableInfo create(DataInput din) throws IOException {
        LocalVariableInfo lvi = new LocalVariableInfo();
        lvi.read(din);
        return lvi;
    }

    private LocalVariableInfo() {
    }

    protected int getNameIndex() {
        return this.u2nameIndex;
    }

    protected void setNameIndex(int index) {
        this.u2nameIndex = index;
    }

    protected int getDescriptorIndex() {
        return this.u2descriptorIndex;
    }

    protected void setDescriptorIndex(int index) {
        this.u2descriptorIndex = index;
    }

    protected void markUtf8Refs(ConstantPool pool) throws ClassFileException {
        pool.incRefCount(this.u2nameIndex);
        pool.incRefCount(this.u2descriptorIndex);
    }

    private void read(DataInput din) throws IOException {
        this.u2startpc = din.readUnsignedShort();
        this.u2length = din.readUnsignedShort();
        this.u2nameIndex = din.readUnsignedShort();
        this.u2descriptorIndex = din.readUnsignedShort();
        this.u2index = din.readUnsignedShort();
    }

    public void write(DataOutput dout) throws IOException {
        dout.writeShort(this.u2startpc);
        dout.writeShort(this.u2length);
        dout.writeShort(this.u2nameIndex);
        dout.writeShort(this.u2descriptorIndex);
        dout.writeShort(this.u2index);
    }

    protected void remap(ClassFile cf, NameMapper nm) throws ClassFileException {
        String oldDesc = cf.getUtf8(this.u2descriptorIndex);
        String newDesc = nm.mapDescriptor(oldDesc);
        this.u2descriptorIndex = cf.remapUtf8To(newDesc, this.u2descriptorIndex);
    }
}

