/*
 * Decompiled with CFR 0.152.
 */
package com.rl.obf.classfile;

import com.rl.obf.classfile.ClassFileException;
import com.rl.obf.classfile.CpInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class Utf8CpInfo
extends CpInfo {
    private int u2length;
    private byte[] bytes;
    private String utf8string;

    protected Utf8CpInfo() {
        super(1);
    }

    public Utf8CpInfo(String s) {
        super(1);
        this.setString(s);
        this.refCount = 1;
    }

    @Override
    public void decRefCount() throws ClassFileException {
        super.decRefCount();
        if (this.refCount == 0) {
            this.clearString();
        }
    }

    public String getString() {
        if (this.utf8string == null) {
            try {
                this.utf8string = new String(this.bytes, "UTF8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return this.utf8string;
    }

    public void setString(String str) {
        this.utf8string = str;
        try {
            this.bytes = str.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.u2length = this.bytes.length;
    }

    public void clearString() {
        this.u2length = 0;
        this.bytes = new byte[0];
        this.utf8string = null;
        this.getString();
    }

    @Override
    protected void readInfo(DataInput din) throws IOException, ClassFileException {
        this.u2length = din.readUnsignedShort();
        this.bytes = new byte[this.u2length];
        din.readFully(this.bytes);
        this.getString();
    }

    @Override
    protected void writeInfo(DataOutput dout) throws IOException, ClassFileException {
        dout.writeShort(this.u2length);
        if (this.bytes.length > 0) {
            dout.write(this.bytes);
        }
    }
}

