/*
 * Decompiled with CFR 0.152.
 */
package com.rl.util.rfc822;

import com.rl.util.rfc822.Header;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Section
implements Iterable<Header> {
    private List<Header> headers = new ArrayList<Header>();

    public void add(Header header) {
        this.headers.add(header);
    }

    public void add(String tag, String value) {
        this.add(new Header(tag, value));
    }

    @Override
    public Iterator<Header> iterator() {
        return this.headers.iterator();
    }

    public boolean hasHeader(Header queryHeader) {
        if (queryHeader != null) {
            for (Header header : this.headers) {
                if (!queryHeader.equals(header)) continue;
                return true;
            }
        }
        return false;
    }

    public Header findTag(String tag) {
        if (tag == null) {
            return null;
        }
        for (Header header : this.headers) {
            if (!tag.equals(header.getTag())) continue;
            return header;
        }
        return null;
    }

    public void writeString(Writer writer) throws IOException {
        for (Header header : this.headers) {
            header.writeString(writer);
        }
        writer.write("\r\n");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Header header : this.headers) {
            sb.append(header.toString());
            sb.append("\r\n");
        }
        sb.append("\r\n");
        return sb.toString();
    }
}

