/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.mmv.gui;

import immibis.bon.gui.Reference;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class BrowseActionListener
implements ActionListener {
    private JComboBox<String> comboBox;
    private boolean isOpen;
    private Component parent;
    private JFileChooser jfc;
    private Reference<File> defaultDir;

    public BrowseActionListener(JComboBox<String> inputField, boolean isOpen, Component parent, boolean dirOnly, Reference<File> defaultDir) {
        this.defaultDir = defaultDir;
        this.comboBox = inputField;
        this.isOpen = isOpen;
        this.parent = parent;
        this.jfc = new JFileChooser();
        this.jfc.setFileSelectionMode(dirOnly ? 1 : 0);
        if (!dirOnly) {
            this.jfc.addChoosableFileFilter(new FileFilter(){

                @Override
                public String getDescription() {
                    return "Jars and zips only";
                }

                @Override
                public boolean accept(File arg0) {
                    String fn = arg0.getName();
                    return arg0.isDirectory() || fn.endsWith(".jar") || fn.endsWith(".zip");
                }
            });
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.jfc.setCurrentDirectory((File)this.defaultDir.val);
        int rv = this.isOpen ? this.jfc.showOpenDialog(this.parent) : this.jfc.showSaveDialog(this.parent);
        if (rv == 0) {
            String path;
            File f = this.jfc.getSelectedFile();
            try {
                path = f.getCanonicalPath();
            }
            catch (IOException e) {
                path = f.getAbsolutePath();
            }
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.comboBox.getModel();
            if (model.getIndexOf(path) != -1) {
                model.removeElement(path);
            }
            this.comboBox.insertItemAt(path, 0);
            this.comboBox.setSelectedItem(path);
        }
        this.defaultDir.val = new File((String)this.comboBox.getSelectedItem());
    }
}

