/*
 * Decompiled with CFR 0.152.
 */
import com.rl.NameProvider;
import com.rl.obf.RetroGuardImpl;
import com.rl.obf.Version;
import java.io.IOException;

public class RetroGuard {
    public static void main(String[] args) throws Exception {
        try {
            if (args.length > 0) {
                if (args[0].equalsIgnoreCase("-help") || args[0].equalsIgnoreCase("--help")) {
                    RetroGuard.showUsage();
                    System.exit(0);
                }
                if (args[0].equalsIgnoreCase("-version") || args[0].equalsIgnoreCase("--version")) {
                    RetroGuard.showVersion();
                    System.exit(0);
                }
            }
            if ((args = NameProvider.parseCommandLine(args)) == null) {
                System.exit(1);
            } else {
                if (args.length < 0 || args.length > 4) {
                    throw new IllegalArgumentException("Invalid number of arguments.");
                }
                String inFilename = args.length < 1 ? null : args[0];
                String outFilename = args.length < 2 ? null : args[1];
                String rgsFilename = args.length < 3 ? null : args[2];
                String logFilename = args.length < 4 ? null : args[3];
                RetroGuardImpl.obfuscate(inFilename, outFilename, rgsFilename, logFilename);
                System.exit(0);
            }
        }
        catch (IllegalArgumentException e) {
            System.err.println();
            System.err.println("ERROR: " + (e.getMessage() != null ? e.getMessage() : "Unknown"));
            e.printStackTrace(System.err);
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println();
            System.err.println("ERROR: " + (e.getMessage() != null ? e.getMessage() : "Unknown"));
            e.printStackTrace(System.err);
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println();
            System.err.println("RetroGuard error: " + e.toString());
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private static void showUsage() {
        System.err.println(Version.getVersionComment());
        System.err.println("Usage: java RetroGuard [INPUT-FILE [OUTPUT-FILE [SCRIPT-FILE [LOG-FILE]]]]");
        System.err.println("  where INPUT-FILE is the JAR to be obfuscated (default: 'in.jar')");
        System.err.println("        OUTPUT-FILE is name for the obfuscated JAR (default: 'out.jar')");
        System.err.println("        SCRIPT-FILE is a valid RetroGuard script (default: 'script.rgs').");
        System.err.println("        LOG-FILE is the name for the log file (default: 'retroguard.log').");
        System.err.println("or for de-obfuscation");
        System.err.println("Usage: java RetroGuard -searge [CONFIG-FILE]");
        System.err.println("  where CONFIG-FILE is the config file (default: 'retroguard.cfg')");
        System.err.println("or for re-obfuscation");
        System.err.println("Usage: java RetroGuard -notch [CONFIG-FILE]");
        System.err.println("  where CONFIG-FILE is the config file (default: 'retroguard.cfg')");
    }

    private static void showVersion() {
        System.err.println(Version.getVersionComment());
    }
}

