/*
 * Decompiled with CFR 0.152.
 */
package com.rl.obf.classfile;

import com.rl.obf.classfile.AttrInfo;
import com.rl.obf.classfile.ClassFile;
import com.rl.obf.classfile.ClassFileException;
import com.rl.obf.classfile.ConstantPool;
import com.rl.obf.classfile.InnerClassesInfo;
import com.rl.obf.classfile.NameMapper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class InnerClassesAttrInfo
extends AttrInfo {
    private List<InnerClassesInfo> classes;

    protected InnerClassesAttrInfo(ClassFile cf, int attrNameIndex, int attrLength) {
        super(cf, attrNameIndex, attrLength);
    }

    @Override
    protected String getAttrName() {
        return "InnerClasses";
    }

    protected List<InnerClassesInfo> getInfo() {
        return this.classes;
    }

    @Override
    protected void markUtf8RefsInInfo(ConstantPool pool) throws ClassFileException {
        for (InnerClassesInfo cl : this.classes) {
            cl.markUtf8Refs(pool);
        }
    }

    @Override
    protected void readInfo(DataInput din) throws IOException, ClassFileException {
        int u2numberOfClasses = din.readUnsignedShort();
        this.classes = new ArrayList<InnerClassesInfo>(u2numberOfClasses);
        for (int i = 0; i < u2numberOfClasses; ++i) {
            this.classes.add(InnerClassesInfo.create(din));
        }
    }

    @Override
    public void writeInfo(DataOutput dout) throws IOException, ClassFileException {
        dout.writeShort(this.classes.size());
        for (InnerClassesInfo cl : this.classes) {
            cl.write(dout);
        }
    }

    @Override
    protected void remap(ClassFile cf, NameMapper nm) throws ClassFileException {
        for (InnerClassesInfo cl : this.classes) {
            cl.remap(cf, nm);
        }
    }
}

