/*
 * Decompiled with CFR 0.152.
 */
package com.rl.obf.classfile;

import com.rl.obf.classfile.ClassCpInfo;
import com.rl.obf.classfile.ClassFile;
import com.rl.obf.classfile.ClassFileException;
import com.rl.obf.classfile.ConstantPool;
import com.rl.obf.classfile.NameMapper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class InnerClassesInfo {
    private int u2innerClassInfoIndex;
    private int u2outerClassInfoIndex;
    private int u2innerNameIndex;
    private int u2innerClassAccessFlags;

    public static InnerClassesInfo create(DataInput din) throws IOException {
        InnerClassesInfo ici = new InnerClassesInfo();
        ici.read(din);
        return ici;
    }

    private InnerClassesInfo() {
    }

    protected int getInnerClassIndex() {
        return this.u2innerClassInfoIndex;
    }

    protected int getInnerNameIndex() {
        return this.u2innerNameIndex;
    }

    protected void setInnerNameIndex(int index) {
        this.u2innerNameIndex = index;
    }

    protected void markUtf8Refs(ConstantPool pool) throws ClassFileException {
        if (this.u2innerNameIndex != 0) {
            pool.incRefCount(this.u2innerNameIndex);
        }
    }

    private void read(DataInput din) throws IOException {
        this.u2innerClassInfoIndex = din.readUnsignedShort();
        this.u2outerClassInfoIndex = din.readUnsignedShort();
        this.u2innerNameIndex = din.readUnsignedShort();
        this.u2innerClassAccessFlags = din.readUnsignedShort();
    }

    public void write(DataOutput dout) throws IOException {
        dout.writeShort(this.u2innerClassInfoIndex);
        dout.writeShort(this.u2outerClassInfoIndex);
        dout.writeShort(this.u2innerNameIndex);
        dout.writeShort(this.u2innerClassAccessFlags);
    }

    protected void remap(ClassFile cf, NameMapper nm) throws ClassFileException {
        if (this.u2innerNameIndex != 0) {
            ClassCpInfo innerClassInfo = (ClassCpInfo)cf.getCpEntry(this.u2innerClassInfoIndex);
            String innerClassName = cf.getUtf8(innerClassInfo.getNameIndex());
            String remapClass = nm.mapClass(innerClassName);
            remapClass = remapClass.substring(remapClass.lastIndexOf(36) + 1);
            this.u2innerNameIndex = cf.remapUtf8To(remapClass, this.u2innerNameIndex);
        }
    }
}

