/*
 * Decompiled with CFR 0.152.
 */
package com.rl.obf.classfile;

import com.rl.obf.classfile.AnnotationInfo;
import com.rl.obf.classfile.ClassFile;
import com.rl.obf.classfile.ClassFileException;
import com.rl.obf.classfile.ConstantPool;
import com.rl.obf.classfile.NameMapper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ParameterAnnotationsInfo {
    private List<AnnotationInfo> annotationTable;

    public static ParameterAnnotationsInfo create(DataInput din) throws IOException, ClassFileException {
        ParameterAnnotationsInfo pai = new ParameterAnnotationsInfo();
        pai.read(din);
        return pai;
    }

    private ParameterAnnotationsInfo() {
    }

    protected void markUtf8Refs(ConstantPool pool) throws ClassFileException {
        for (AnnotationInfo a : this.annotationTable) {
            a.markUtf8Refs(pool);
        }
    }

    private void read(DataInput din) throws IOException, ClassFileException {
        int u2numAnnotations = din.readUnsignedShort();
        this.annotationTable = new ArrayList<AnnotationInfo>(u2numAnnotations);
        for (int i = 0; i < u2numAnnotations; ++i) {
            this.annotationTable.add(AnnotationInfo.create(din));
        }
    }

    public void write(DataOutput dout) throws IOException, ClassFileException {
        dout.writeShort(this.annotationTable.size());
        for (AnnotationInfo a : this.annotationTable) {
            a.write(dout);
        }
    }

    protected void remap(ClassFile cf, NameMapper nm) throws ClassFileException {
        for (AnnotationInfo a : this.annotationTable) {
            a.remap(cf, nm);
        }
    }
}

