/*
 * Decompiled with CFR 0.152.
 */
package com.rl.obf.classfile;

import com.rl.obf.classfile.AttrInfo;
import com.rl.obf.classfile.ClassFile;
import com.rl.obf.classfile.ClassFileException;
import com.rl.obf.classfile.ConstantPool;
import com.rl.obf.classfile.StackMapFrameInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class StackMapTableAttrInfo
extends AttrInfo {
    private List<StackMapFrameInfo> entries;

    protected StackMapTableAttrInfo(ClassFile cf, int attrNameIndex, int attrLength) {
        super(cf, attrNameIndex, attrLength);
    }

    @Override
    protected String getAttrName() {
        return "StackMapTable";
    }

    @Override
    protected void markUtf8RefsInInfo(ConstantPool pool) throws ClassFileException {
        for (StackMapFrameInfo smf : this.entries) {
            smf.markUtf8Refs(pool);
        }
    }

    @Override
    protected void readInfo(DataInput din) throws IOException, ClassFileException {
        int u2numberOfEntries = din.readUnsignedShort();
        this.entries = new ArrayList<StackMapFrameInfo>(u2numberOfEntries);
        for (int i = 0; i < u2numberOfEntries; ++i) {
            StackMapFrameInfo smf = StackMapFrameInfo.create(din);
            this.entries.add(smf);
        }
    }

    @Override
    public void writeInfo(DataOutput dout) throws IOException, ClassFileException {
        dout.writeShort(this.entries.size());
        for (StackMapFrameInfo smf : this.entries) {
            smf.write(dout);
        }
    }
}

